#ifndef CORONAWINDOW_H
#define CORONAWINDOW_H
#include "categorywindow.h"

namespace Ui {
    class CoronaWindow;
}

class CoronaWindow : public CategoryWindow
{
    Q_OBJECT

public:
    explicit CoronaWindow(CategoryWindow *parent = 0);
    virtual ~CoronaWindow();

    virtual bool addCorona(Data* corona);
    virtual bool setTableResize();

protected:
    void changeEvent(QEvent *e);
    void resizeEvent(QResizeEvent *);

private:
    Ui::CoronaWindow *ui;
    QList<Data*> _coronaList;
    QHash<int, Data*> _coronaTokugiList;

    QTableWidget *_tokugiTableWidget;

signals:
    void selectedCorona(Data *corona);
    void selectedCoronaTokugi(Data *tokugi);

private slots:
    void on_GetCoronaTokugiButton_clicked();
    void on_GetCoronaButton_clicked();
    void on_CoronaTableWidget_cellClicked(int row, int column);
    void on_CoronaTokugiTableWidget_cellClicked(int row, int column);
};

#endif // CORONAWINDOW_H
