#ifndef DATA_H
#define DATA_H
#include <QList>
#include <QVector>
#include <QString>
#include <QTableWidget>

class Category;
class Tokugi;

class Data
{
public:
    Data();
    Data(QString);
    virtual ~Data();

    //Common
    virtual bool Add(Data *data);
    virtual bool Remove(Data *data);
    virtual Data* GetChild(int number);
    virtual Data* GetParent();
    virtual bool SetParent(Data *parent);
    virtual Category* GetCategory();
    virtual QString GetName();
    virtual bool SetName(QString);
    virtual bool IsOwned();
    virtual bool SetOwned(bool isOwned);
    virtual bool OwnAdd(Data* data);
    virtual bool OwnRemove(Data* data);
    virtual Data* GetOwnChild(int number);

    //Category
    virtual QVector<int> GetKihonCapability();
    virtual int GetKihonCapability(int);
    virtual bool SetKihonCapability(QVector<int>);
    virtual QVector<int> GetSentouCapability();
    virtual int GetSentouCapability(int);
    virtual bool SetSentouCapability(QVector<int>);
    virtual QList<Data*> getAutoGetTokugiList();
    virtual bool addAutGetTokugiList(Data*);
    virtual QTableWidget* getTokugiTableWidget();
    virtual bool setTokugiTableWidget(QTableWidget*);

    //Tokugi
    virtual QString GetReference();
    virtual bool SetReference(QString);
    virtual QString GetType();
    virtual bool SetType(QString);
    virtual QString GetCapability();
    virtual bool SetCapability(QString);
    virtual QString GetTiming();
    virtual bool SetTiming(QString);
    virtual QString GetCost();
    virtual bool SetCost(QString);
    virtual QString GetDetail();
    virtual bool SetDetail(QString);
    virtual bool AddDetail(QString);
    virtual QVector<QString> GetProperty();

    virtual int GetTotalInitialLevel();
    virtual int GetTotalExperimentalLevel();
    virtual int GetInitialLevel();
    virtual int GetExperimentalLevel();
    virtual bool IncreaseInitialLevel();
    virtual bool DecreaseInitialLevel();
    virtual bool IncreaseExperimentalLevel();
    virtual bool DecreaseExperimentalLevel();

protected:
    Data* _parent;
    QString _name;
    bool _isOwned;
    QList<Data*> _ownChildList;
};

#endif // DATA_H   
