#include "filedataregexp.h"
#include <QMessageBox>
#include <QDebug>
#include "corona.h"
#include "meme.h"
#include "branch.h"
#include "tokugi.h"

FileDataRegExp::FileDataRegExp(){}

FileDataRegExp* FileDataRegExp::getInstance()
{
    if(_singlton == NULL)
    {
         _singlton = new FileDataRegExp;
    }
    return _singlton;
}

FileDataRegExp* FileDataRegExp::_singlton = NULL;
//Data* _active = NULL;
Data* FileDataRegExp::_active = NULL;
QList<QString> FileDataRegExp::_list;
Data* FileDataRegExp::_corona = NULL;
Data* FileDataRegExp::_meme = NULL;
Data* FileDataRegExp::_branch = NULL;
Data* FileDataRegExp::_tokugi = NULL;

FileDataInterpreter* FileDataRegExp::_interpreter = NULL;
CoronaDataInterpreter* FileDataRegExp::_ci = new CoronaDataInterpreter;
MemeDataInterpreter* FileDataRegExp::_mi = new MemeDataInterpreter;
BranchDataInterpreter* FileDataRegExp::_bi = new BranchDataInterpreter;
TokugiDataInterpreter* FileDataRegExp::_ti = new TokugiDataInterpreter;

bool FileDataRegExp::Initialize()
{
    _active = NULL;
    _corona = NULL;
    _meme = NULL;
    _branch = NULL;
    _tokugi = NULL;
    _interpreter = NULL;

    return true;
}

bool FileDataRegExp::Define(QString str, Data * data)
{
    QRegExp coronaRegExp("^【(.+)】(/(\\d+/){10})");
    QRegExp memeRegExp("^#(.+)(/(\\d+/){5})");
    QRegExp branchRegExp("^【(.+)】(/(\\d+/){5})");
    QRegExp capability10("/(\\d+)/(\\d+)/(\\d+)/(\\d+)/(\\d+)/(\\d+)/(\\d+)/(\\d+)/(\\d+)/(\\d+)/");
    QRegExp capability5("/(\\d+)/(\\d+)/(\\d+)/(\\d+)/(\\d+)/");
    QRegExp tokugi2("^【([^／]+)／([^／]+)／([^／]+)／([^／]+)／([^／]+)】(.+$)");
    tokugi2.setMinimal(true);
    QRegExp tokugi1("^【([^(／)]+)／([^(／)]+)／([^(／)]+)／([^(／)]+)】(.+$)");
    tokugi1.setMinimal(true);
    QRegExp tokugiDetail("[(　)\\s]*([^(　)\\s]*)[(　)\\s]*$");
    tokugi1.setMinimal(true);

    if(_active == NULL)
    {
        _active = data;
    }
    if( coronaRegExp.indexIn(str) > -1)
    {
        _interpreter = _ci;
        if(!_list.isEmpty())
        {
            _list.clear();
        }
        _list << coronaRegExp.cap(1);

        if( capability10.indexIn(coronaRegExp.cap(2)) > -1)
        {
            for(int i=1;i<=10;i++)
            {
                _list << capability10.cap(i);
            }
        }
        _corona = _interpreter->Interpret(_list, data); //読み込みからインスタンス生成
        _active = _corona;
    }
    else if( memeRegExp.indexIn(str) > -1)
    {
        _interpreter = _mi;
        if(!_list.isEmpty())
        {
            _list.clear();
        }
        _list << memeRegExp.cap(1);
        if( capability5.indexIn(memeRegExp.cap(2)) > -1)
        {
            for(int i=1;i<=5;i++)
            {
                _list << capability5.cap(i);
            }
        }
        _meme = _interpreter->Interpret(_list, data); //読み込みからインスタンス生成
        _active = _meme;
    }
    else if( branchRegExp.indexIn(str) > -1)
    {
        _interpreter = _bi;
        if(!_list.isEmpty())
        {
            _list.clear();
        }
        _list << branchRegExp.cap(1);
        if( capability5.indexIn(branchRegExp.cap(2)) > -1)
        {
            for(int i=1;i<=5;++i)
            {
                _list << capability5.cap(i);
            }
        }
        _branch = _interpreter->Interpret(_list, _meme); //読み込みからインスタンス生成
        _active = _branch;
    }
    else if( tokugi2.indexIn(str) > -1)
    {
        //1name2reference3type4capability5timing6cost7detail
        _interpreter = _ti;
        if(!_list.isEmpty())
        {
            _list.clear();
        }
        _list.append(tokugi2.cap(6));
        for(int i=1;i<=5;i++)
        {
            _list.append(tokugi2.cap(i));
        }
        _tokugi = _interpreter->Interpret(_list, _active); //読み込みからインスタンス生成
    }
    else if( tokugi1.indexIn(str) > -1)
    {
        _interpreter = _ti;
        if(!_list.isEmpty())
        {
            _list.clear();
        }
        _list.append(tokugi1.cap(5));
        for(int i=1;i<=6;++i)
        {
            if(i == 2)
            {
                _list.append(QString("-"));
            }
            _list.append(tokugi1.cap(i));
        }
        _tokugi = _interpreter->Interpret(_list, _active); //読み込みからインスタンス生成
    }
    else if( tokugiDetail.indexIn(str) > -1)
    {
        if(_tokugi != NULL)
        {
            _interpreter->Interpret(tokugiDetail.cap(1), _tokugi); //読み込みからインスタンス生成
        }
        else
        {
            int ret = QMessageBox::warning(NULL, tr("Warning"), tr("なんらかの文法エラー\nまたは文字コエンードがutf-8でないかもしれない\n") += str, QMessageBox::Ok | QMessageBox::Abort, QMessageBox::NoButton);
            switch(ret)
            {
            case QMessageBox::Ok:
                break;
            case QMessageBox::Abort:
                return false;
                break;
            default:
                return false;
                break;
            }
        }
    }
    else
    {
        QMessageBox::warning(NULL, tr("Warning"), tr("ファイル読み込み正規表現で何らかのエラー\n") += str, QMessageBox::Ok, QMessageBox::NoButton);
    }
    return true;
}
