#include "mainwindow.h"
#include "ui_mainwindow.h"
#include <QDebug>
#include <QMessageBox>
#include <QFile>
#include <QFileDialog>
#include <QDir>
#include <cmath>

MainWindow::MainWindow(QWidget *parent) :
        QMainWindow(parent),
        ui(new Ui::MainWindow)
{
    ui->setupUi(this);
     _aif = new ApplicationnInformaitonForm;
     _aif->setWindowTitle("バージョン情報");
     connect(_aif, SIGNAL(hideForm()), this, SLOT(hideApplicationInformationForm()) );
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::changeEvent(QEvent *e)
{
    QMainWindow::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

bool MainWindow::setGeneral(Data *general)
{
    _general = general;
    return true;
}

bool MainWindow::setCoronaWindow(CoronaWindow* cw)
{
    _cw = cw;
    return true;
}

bool MainWindow::setMemeWindow(MemeWindow* mw)
{
    _mw = mw;
    return true;
}

bool MainWindow::setOwnCoronaForm(OwnCoronaForm* ocf)
{
    _ocf = ocf;
    return true;
}

bool MainWindow::setPossibleTokugiForm(PossibleTokugiForm *ptf)
{
    _ptf = ptf;
    return true;
}

void MainWindow::on_action_2_triggered()
{
    _cw->show();
}

void MainWindow::on_action_3_triggered()
{
    _mw->show();
}

void MainWindow::on_action_4_triggered()
{
    _ptf->show();
}

void MainWindow::on_action_5_triggered()
{
    _ocf->show();
}

void MainWindow::closeEvent(QCloseEvent *event)
{
    event->accept();
}

/**
  キャラクターデータ出力
  */
void MainWindow::on_action_triggered()
{
    QDir dir(QDir::current());
    dir.mkdir("CharaData");
    QString fileName = QFileDialog::getSaveFileName(this,
        tr("Write File"), "CharaData", tr("text Files (*.txt)"));
    QFile data(fileName);
    if (data.open(QFile::WriteOnly | QFile::Truncate))
    {
	QTextStream out(&data);

        out << tr("■基本データ\n");
        out << tr("【コロナ】");
	QList<Data*> coronaList = _ocf->GetOwnCoronaList();
	for(int i=0;i<coronaList.size();++i)
	{
	    if(i>0)
	    {
                out << tr("／");
	    }
	    out << coronaList.at(i)->GetName();
	}
	out << "\n";
        out << tr("【ミーム】");
	QList<Data*> memeList = _ocf->GetOwnMemeList();
	for(int i=0;i<memeList.size();++i)
	{
	    if(i>0)
	    {
                 out << tr("／");
	    }
	    out << memeList.at(i)->GetName();
	}
	out << "\n";
        out << tr("【ブランチ】");
	QList<Data*> branchList = _ocf->GetOwnBranchList();
	for(int i=0;i<branchList.size();++i)
	{
	    if(i>0)
	    {
                 out << tr("／");
	    }
	    out << branchList.at(i)->GetName();
	}
	out << "\n";

        out << tr("【消費経験点】　0（能力値：0　特技：0　装備：0　パスの追加：0　ブランチの追加：0）\n");

	Data* corona = NULL;
	if(_ocf->GetOwnCoronaList()!=QList<Data*>())
	{
	    corona = _ocf->GetOwnCoronaList().at(0);
	}
	Data* meme = _ocf->GetMainMeme();
	Data* branch = _ocf->GetMainBranch();
	QVector<int> kihon(5,0);
	QVector<int> sentou(5,0);

	if( (corona!=NULL) && (meme!=NULL) && (branch!=NULL) )
	{
	    for(int i=0;i<5;++i)
	    {
		kihon.replace(i, corona->GetKihonCapability(i) + meme->GetKihonCapability(i) );
		sentou.replace(i, corona->GetSentouCapability(i) + branch->GetSentouCapability(i) );
	    }
	}

	out << "\n";
        out << tr("■能力値／耐久力\n");
        out << tr("【能力値】　　　　");
        out << tr("肉体") << kihon.at(0) << tr("　　");
        out << tr("技術") << kihon.at(1) << tr("　　");
        out << tr("魔術") << kihon.at(2) << tr("　　");
        out << tr("社会") << kihon.at(3) << tr("　　");
        out << tr("根源") << kihon.at(4) << "\n";
        out << tr("【戦闘値元値】　　");
        out << tr("白兵") << sentou.at(0) << tr("　　");
        out << tr("射撃") << sentou.at(1) << tr("　　");
        out << tr("回避") << sentou.at(2) << tr("　　");
        out << tr("心魂") << sentou.at(3) << tr("　　");
        out << tr("行動") << sentou.at(4) << "\n";
        out << tr("【戦闘値修正値】　");
        out << tr("白兵") << sentou.at(0) << tr(" 　");
        out << tr("射撃") << sentou.at(1) << tr("　　");
        out << tr("回避") << sentou.at(2) << tr("　　");
        out << tr("心魂") << sentou.at(3) << tr("　　");
        out << tr("行動") << sentou.at(4) << "\n";

        out << tr("【ＨＰ】　　　　　元値：") << kihon.at(1) + kihon.at(2) + kihon.at(3) << tr("　　修正値：") << kihon.at(1) + kihon.at(2) + kihon.at(3) << "\n";
        out << tr("【ＬＰ】　　　　　元値：") << ceil( (kihon.at(0) + kihon.at(4) )/2.0 ) << tr("　　修正値：") << (kihon.at(0) + kihon.at(4) )/2 <<"\n";

	out << "\n";
        out << tr("■宿命／特徴／闘争／邂逅\n");
        out << tr("宿命：　　　特徴：　　　特徴効果：\n");
        out << tr("闘争：　　　邂逅：\n");

	out << tr("\n");
        out << tr("■初期パス\n");
        out << tr("【因縁】からの\n");

	out << ("\n");
        out << tr("■準備された装備\n");
        out << tr("部位：名称（必要能力／行動修正／ダメージ／HP修正／射程／備考／参照P）\n");
        out << tr("右手　：　　　　　　　　　　　　　　　（必：―／行：―／ダ：―／HP：―／射：―／―／―）\n");
        out << tr("左手　：　　　　　　　　　　　　　　　（必：―／行：―／ダ：―／HP：―／射：―／―／―）\n");
        out << tr("胴部　：　　　　　　　　　　　　　　　（必：―／行：―／ダ：―／HP：―／射：―／―／―）\n");
        out << tr("その他：　　　　　　　　　　　　　　　（必：―／行：―／ダ：―／HP：―／射：―／―／―）\n");
        out << tr("乗り物：　　　　　　　　　　　　　　　（必：―／行：―／ダ：―／HP：―／射：―／―／―）\n");
        out << tr("予備１：　　　　　　　　　　　　　　　（必：―／行：―／ダ：―／HP：―／射：―／―／―）\n");
        out << tr("予備２：　　　　　　　　　　　　　　　（必：―／行：―／ダ：―／HP：―／射：―／―／―）\n");
        out << tr("予備３：　　　　　　　　　　　　　　　（必：―／行：―／ダ：―／HP：―／射：―／―／―）\n");

	out << "\n";
        out << tr("■コロナ特技\n");
	foreach(Data* corona, coronaList)
	{
	    out << GetWritenTokugi(corona);
	}

	out << "\n";
        out << tr("■ミーム特技\n");
	foreach(Data* meme, memeList)
	{
	    out << GetWritenTokugi(meme);
	    for(int i=0;meme->GetOwnChild(i)!=NULL;++i)
	    {
		if(meme->GetOwnChild(i)->GetCategory()!=NULL)
		{
		    out << GetWritenTokugi(meme->GetOwnChild(i));
		}
	    }
	}
	out << GetWritenTokugi(_general);

	out << "\n";
        out << tr("■装備\n");

	out << "\n";
        out << tr("■属性防御\n");
        out << tr("肉体：×　技術：×　魔術：×　社会：×\n");

	out << "\n";
        out << tr("■戦術、設定、メモなど\n\n");
    }
}

QString MainWindow::GetWritenTokugi(Data *parent)
{
    QString lines;
    for(int i=0;parent->GetOwnChild(i)!=NULL;++i)
    {
	Data* tokugi = parent->GetOwnChild(i);
	if(tokugi->GetCategory()!=NULL)
	{
	    continue;
	}
	QVector<QString> property = tokugi->GetProperty();
        lines.append(tr("【") );
	for(int j=1;j<6;++j)
	{
            lines.append(property.at(j) ).append(tr("／") );
	}
        lines.append(tr("】") );
	lines.append(property.at(0) );
	if(tokugi->GetInitialLevel() + tokugi->GetExperimentalLevel() > 1)
	{
	    lines.append(QString::number(tokugi->GetInitialLevel() + tokugi->GetExperimentalLevel() ) );
	}
	lines.append("\n");
        lines.append(tr("　")).append(property.at(6) ).append("\n");
    }
    return lines;
}

//public slots
void MainWindow::hideApplicationInformationForm()
{
    _aif->hide();
}

//private slots

void MainWindow::on_applicationInformation_triggered()
{
    _aif->show();
}

void MainWindow::on_applicationExit_triggered()
{
    emit applicationExit();
}
