#ifndef TOKUGI_H
#define TOKUGI_H
#include "data.h"

class Tokugi : public Data
{
public:
    Tokugi();
    Tokugi(QString name, Data *parent);
    virtual ~Tokugi();

    virtual QString GetName();
    virtual bool SetName(QString name);

    virtual QString GetReference();
    virtual bool SetReference(QString);
    virtual QString GetType();
    virtual bool SetType(QString);
    virtual QString GetCapability();
    virtual bool SetCapability(QString);
    virtual QString GetTiming();
    virtual bool SetTiming(QString);
    virtual QString GetCost();
    virtual bool SetCost(QString);
    virtual QString GetDetail();
    virtual bool SetDetail(QString);
    virtual bool AddDetail(QString);
    virtual QVector<QString> GetProperty();

    virtual int GetTotalInitialLevel();
    virtual int GetTotalExperimentalLevel();
    virtual int GetInitialLevel();
    virtual int GetExperimentalLevel();
    virtual bool IncreaseInitialLevel();
    virtual bool DecreaseInitialLevel();
    virtual bool IncreaseExperimentalLevel();
    virtual bool DecreaseExperimentalLevel();

private:
    QVector<QString> _property;
    static int _totalInitialLevel;
    static int _totalExperimentalLevel;
    int _initialLevel;
    int _experimentalLevel;
};

#endif // TOKUGI_H
