/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.chaplet.dx.ui;

import application.ApplicationContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jp.sf.chaplet.core.client.ClientPlugin;
import jp.sf.chaplet.core.ui.IPluginView;
import jp.sf.chaplet.dx.DiceRoll;
import jp.sf.chaplet.dx.DxUtils;
import jp.sf.chaplet.dx.ui.LoisTableModel;
import jp.sf.chaplet.swing.UniqueComboBoxModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DxView
extends JPanel
implements IPluginView {
    private static final long serialVersionUID = 1L;
    private JPanel dicePanel = null;
    private JPanel hpPanel = null;
    private JPanel loisPanel = null;
    private JLabel jLabel = null;
    private JSpinner diceSpinner = null;
    private JLabel jLabel1 = null;
    private JSpinner bonusSpinner = null;
    private JLabel jLabel2 = null;
    private JSpinner criticalSpinner = null;
    private JLabel jLabel3 = null;
    private JComboBox historyCombo = null;
    private JToggleButton hideButton = null;
    private JPanel buttonPanel = null;
    private JButton rollButton = null;
    private JButton damageButton = null;
    private JButton oneDiceButton = null;
    private JButton twoDiceButton = null;
    private JLabel jLabel4 = null;
    private JLabel jLabel5 = null;
    private JSpinner hpSpinner = null;
    private JSpinner invasionSpinner = null;
    private JButton invAdd5Button = null;
    private JProgressBar invasionBar = null;
    private JPanel bonusPanel = null;
    private JLabel jLabel6 = null;
    private JTextField diceBonusText = null;
    private JLabel jLabel7 = null;
    private JLabel jLabel8 = null;
    private JTextField efectLvText = null;
    private JTextField targetBonusText = null;
    private JScrollPane jScrollPane = null;
    private JTable loisTable = null;
    private LoisTableModel loisTableModel = null;
    private JButton hpAdd5Button = null;
    private UniqueComboBoxModel<DiceRoll> historyComboModel = null;
    private ActionMap actionMap;
    private JButton clearButton = null;
    private SpinnerNumberModel invasionModel = null;

    public DxView() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.weighty = 20.0;
        gridBagConstraints2.weightx = 1.0;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.weighty = 1.0;
        gridBagConstraints1.weightx = 1.0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridy = 0;
        this.setSize(352, 373);
        this.setLayout(new GridBagLayout());
        this.setName("dxView");
        this.add((Component)this.getDicePanel(), gridBagConstraints);
        this.add((Component)this.getHpPanel(), gridBagConstraints1);
        this.add((Component)this.getLoisPanel(), gridBagConstraints2);
    }

    private JPanel getDicePanel() {
        if (this.dicePanel == null) {
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.gridx = 0;
            gridBagConstraints13.fill = 2;
            gridBagConstraints13.gridwidth = 7;
            gridBagConstraints13.ipady = 0;
            gridBagConstraints13.insets = new Insets(3, 0, 3, 0);
            gridBagConstraints13.gridy = 2;
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 6;
            gridBagConstraints12.fill = 2;
            gridBagConstraints12.gridy = 0;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.fill = 1;
            gridBagConstraints11.gridy = 1;
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.gridwidth = 5;
            gridBagConstraints11.gridx = 1;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 0;
            gridBagConstraints10.ipady = 10;
            gridBagConstraints10.gridy = 1;
            this.jLabel3 = new JLabel();
            this.jLabel3.setText("\u5c65\u6b74");
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 5;
            gridBagConstraints8.fill = 1;
            gridBagConstraints8.weightx = 10.0;
            gridBagConstraints8.gridy = 0;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 4;
            gridBagConstraints7.weightx = 10.0;
            gridBagConstraints7.gridy = 0;
            this.jLabel2 = new JLabel();
            this.jLabel2.setText("\u30af\u30ea\u30c6\u30a3\u30ab\u30eb");
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 3;
            gridBagConstraints6.fill = 1;
            gridBagConstraints6.weightx = 10.0;
            gridBagConstraints6.gridy = 0;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 2;
            gridBagConstraints5.weightx = 10.0;
            gridBagConstraints5.gridy = 0;
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("D10+");
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.fill = 1;
            gridBagConstraints4.weightx = 10.0;
            gridBagConstraints4.gridy = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.weightx = 10.0;
            gridBagConstraints3.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints3.ipady = 10;
            gridBagConstraints3.gridy = 0;
            this.jLabel = new JLabel();
            this.jLabel.setText("\u30c0\u30a4\u30b9");
            this.dicePanel = new JPanel();
            this.dicePanel.setLayout(new GridBagLayout());
            this.dicePanel.setBorder(BorderFactory.createTitledBorder(null, "\u30c0\u30a4\u30b9", 0, 0, new Font("MS UI Gothic", 0, 12), Color.black));
            this.dicePanel.add((Component)this.jLabel, gridBagConstraints3);
            this.dicePanel.add((Component)this.getDiceSpinner(), gridBagConstraints4);
            this.dicePanel.add((Component)this.jLabel1, gridBagConstraints5);
            this.dicePanel.add((Component)this.getBonusSpinner(), gridBagConstraints6);
            this.dicePanel.add((Component)this.jLabel2, gridBagConstraints7);
            this.dicePanel.add((Component)this.getCriticalSpinner(), gridBagConstraints8);
            this.dicePanel.add((Component)this.jLabel3, gridBagConstraints10);
            this.dicePanel.add((Component)this.getHistoryCombo(), gridBagConstraints11);
            this.dicePanel.add((Component)this.getHideButton(), gridBagConstraints12);
            this.dicePanel.add((Component)this.getButtonPanel(), gridBagConstraints13);
        }
        return this.dicePanel;
    }

    private JPanel getHpPanel() {
        if (this.hpPanel == null) {
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 4;
            gridBagConstraints9.gridheight = 2;
            gridBagConstraints9.gridy = 0;
            GridBagConstraints gridBagConstraints30 = new GridBagConstraints();
            gridBagConstraints30.gridx = 2;
            gridBagConstraints30.insets = new Insets(0, 0, 2, 0);
            gridBagConstraints30.gridy = 0;
            this.jLabel8 = new JLabel();
            this.jLabel8.setText("\u76ee\u6a19\u5024\u5909\u5316");
            this.jLabel7 = new JLabel();
            this.jLabel7.setText("\u30a8\u30d5\u30a7\u30af\u30c8Lv");
            GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
            gridBagConstraints20.gridx = 5;
            gridBagConstraints20.fill = 1;
            gridBagConstraints20.gridheight = 3;
            gridBagConstraints20.weightx = 10.0;
            gridBagConstraints20.gridy = 0;
            GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
            gridBagConstraints19.gridx = 0;
            gridBagConstraints19.gridwidth = 5;
            gridBagConstraints19.fill = 2;
            gridBagConstraints19.insets = new Insets(5, 0, 0, 0);
            gridBagConstraints19.gridy = 2;
            GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
            gridBagConstraints18.gridx = 2;
            gridBagConstraints18.weightx = 5.0;
            gridBagConstraints18.gridwidth = 2;
            gridBagConstraints18.anchor = 17;
            gridBagConstraints18.insets = new Insets(0, 0, 2, 0);
            gridBagConstraints18.gridy = 1;
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.gridx = 1;
            gridBagConstraints17.fill = 1;
            gridBagConstraints17.weightx = 10.0;
            gridBagConstraints17.gridy = 1;
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.gridx = 1;
            gridBagConstraints16.fill = 1;
            gridBagConstraints16.weightx = 10.0;
            gridBagConstraints16.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints16.gridy = 0;
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.gridx = 0;
            gridBagConstraints15.weightx = 1.0;
            gridBagConstraints15.gridy = 1;
            this.jLabel5 = new JLabel();
            this.jLabel5.setText("\u4fb5\u98df\u7387");
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.gridx = 0;
            gridBagConstraints14.weightx = 1.0;
            gridBagConstraints14.gridy = 0;
            this.jLabel4 = new JLabel();
            this.jLabel4.setText("HP");
            this.hpPanel = new JPanel();
            this.hpPanel.setLayout(new GridBagLayout());
            this.hpPanel.setBorder(BorderFactory.createTitledBorder(null, "HP\u30fb\u4fb5\u98df\u7387", 0, 0, new Font("MS UI Gothic", 0, 12), Color.black));
            this.hpPanel.add((Component)this.jLabel4, gridBagConstraints14);
            this.hpPanel.add((Component)this.jLabel5, gridBagConstraints15);
            this.hpPanel.add((Component)this.getHpSpinner(), gridBagConstraints16);
            this.hpPanel.add((Component)this.getInvasionSpinner(), gridBagConstraints17);
            this.hpPanel.add((Component)this.getInvAdd5Button(), gridBagConstraints18);
            this.hpPanel.add((Component)this.getInvasionBar(), gridBagConstraints19);
            this.hpPanel.add((Component)this.getBonusPanel(), gridBagConstraints20);
            this.hpPanel.add((Component)this.getHpAdd5Button(), gridBagConstraints30);
            this.hpPanel.add((Component)this.getClearButton(), gridBagConstraints9);
        }
        return this.hpPanel;
    }

    private JPanel getLoisPanel() {
        if (this.loisPanel == null) {
            GridBagConstraints gridBagConstraints27 = new GridBagConstraints();
            gridBagConstraints27.fill = 1;
            gridBagConstraints27.gridy = 0;
            gridBagConstraints27.weightx = 1.0;
            gridBagConstraints27.weighty = 1.0;
            gridBagConstraints27.gridx = 0;
            this.loisPanel = new JPanel();
            this.loisPanel.setLayout(new GridBagLayout());
            this.loisPanel.setBorder(BorderFactory.createTitledBorder(null, "\u30ed\u30a4\u30b9", 0, 0, new Font("MS UI Gothic", 0, 12), Color.black));
            this.loisPanel.add((Component)this.getJScrollPane(), gridBagConstraints27);
        }
        return this.loisPanel;
    }

    public JSpinner getDiceSpinner() {
        if (this.diceSpinner == null) {
            this.diceSpinner = new JSpinner();
            this.diceSpinner.setValue(1);
        }
        return this.diceSpinner;
    }

    public JSpinner getBonusSpinner() {
        if (this.bonusSpinner == null) {
            this.bonusSpinner = new JSpinner();
        }
        return this.bonusSpinner;
    }

    public JSpinner getCriticalSpinner() {
        if (this.criticalSpinner == null) {
            this.criticalSpinner = new JSpinner();
            this.criticalSpinner.setValue(10);
        }
        return this.criticalSpinner;
    }

    public JComboBox getHistoryCombo() {
        if (this.historyCombo == null) {
            this.historyCombo = new JComboBox();
            this.historyCombo.setModel(this.getHistoryComboModel());
            this.historyCombo.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    DiceRoll roll = (DiceRoll)DxView.this.historyCombo.getSelectedItem();
                    if (roll != null) {
                        DxView.this.getDiceSpinner().setValue(roll.getNumDice());
                        DxView.this.getBonusSpinner().setValue(roll.getBonus());
                        DxView.this.getCriticalSpinner().setValue(roll.getCritical());
                    }
                }
            });
        }
        return this.historyCombo;
    }

    public JToggleButton getHideButton() {
        if (this.hideButton == null) {
            this.hideButton = new JToggleButton();
            this.hideButton.setText("\u96a0\u3059");
            this.hideButton.setName("hideButton");
        }
        return this.hideButton;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(1);
            gridLayout.setHgap(3);
            gridLayout.setVgap(3);
            gridLayout.setColumns(4);
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(gridLayout);
            this.buttonPanel.add((Component)this.getRollButton(), null);
            this.buttonPanel.add((Component)this.getDamageButton(), null);
            this.buttonPanel.add((Component)this.getOneDiceButton(), null);
            this.buttonPanel.add((Component)this.getTwoDiceButton(), null);
        }
        return this.buttonPanel;
    }

    private JButton getRollButton() {
        if (this.rollButton == null) {
            this.rollButton = new JButton();
            this.rollButton.setText("\u5224\u5b9a");
            this.rollButton.setEnabled(false);
            this.rollButton.setName("rollButton");
            this.rollButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DxView.this.actionMap.get("rollSum").actionPerformed(e);
                }
            });
        }
        return this.rollButton;
    }

    private JButton getDamageButton() {
        if (this.damageButton == null) {
            this.damageButton = new JButton();
            this.damageButton.setText("\u30c0\u30e1\u30fc\u30b8");
            this.damageButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DxView.this.actionMap.get("rollDamage").actionPerformed(e);
                }
            });
            this.damageButton.setEnabled(false);
            this.damageButton.setName("damageButton");
        }
        return this.damageButton;
    }

    private JButton getOneDiceButton() {
        if (this.oneDiceButton == null) {
            this.oneDiceButton = new JButton();
            this.oneDiceButton.setText("1D10");
            this.oneDiceButton.setEnabled(false);
            this.oneDiceButton.setName("oneDiceButton");
            this.oneDiceButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DxView.this.actionMap.get("roll1d").actionPerformed(e);
                }
            });
        }
        return this.oneDiceButton;
    }

    private JButton getTwoDiceButton() {
        if (this.twoDiceButton == null) {
            this.twoDiceButton = new JButton();
            this.twoDiceButton.setText("2D10");
            this.twoDiceButton.setEnabled(false);
            this.twoDiceButton.setName("twoDiceButton");
            this.twoDiceButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DxView.this.actionMap.get("roll2d").actionPerformed(e);
                }
            });
        }
        return this.twoDiceButton;
    }

    public JSpinner getHpSpinner() {
        if (this.hpSpinner == null) {
            this.hpSpinner = new JSpinner();
            this.hpSpinner.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    int value = (Integer)DxView.this.hpSpinner.getValue();
                    if (value < 0) {
                        DxView.this.hpSpinner.setValue(0);
                    }
                    DxView.this.actionMap.get("setStatus").actionPerformed(new ActionEvent(DxView.this.hpSpinner, 1001, "setStatus"));
                }
            });
        }
        return this.hpSpinner;
    }

    public JSpinner getInvasionSpinner() {
        if (this.invasionSpinner == null) {
            this.invasionSpinner = new JSpinner();
            this.invasionSpinner.setModel(this.getInvasionModel());
            this.invasionSpinner.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    int invasion = (Integer)DxView.this.invasionSpinner.getValue();
                    DxView.this.invasionBar.setValue(invasion);
                    if (DxView.this.invasionBar.getValue() >= 100) {
                        DxView.this.invasionBar.setForeground(Color.RED);
                    } else {
                        DxView.this.invasionBar.setForeground(Color.BLUE);
                    }
                    DxView.this.getDiceBonusText().setText(String.valueOf(DxUtils.getDiceBonus(invasion, DxView.this.getLoisTableModel().isOrigin())));
                    DxView.this.getEfectLvText().setText(String.valueOf(DxUtils.getLevelBonus(invasion, DxView.this.getLoisTableModel().isOrigin())));
                    DxView.this.getTargetBonusText().setText(String.valueOf(DxUtils.getTargetBonus(invasion, DxView.this.getLoisTableModel().isOrigin())));
                    DxView.this.actionMap.get("setStatus").actionPerformed(new ActionEvent(DxView.this.invasionSpinner, 1001, "setStatus"));
                }
            });
        }
        return this.invasionSpinner;
    }

    private JButton getInvAdd5Button() {
        if (this.invAdd5Button == null) {
            this.invAdd5Button = new JButton();
            this.invAdd5Button.setText("+5");
            this.invAdd5Button.setName("invAdd5Button");
            this.invAdd5Button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DxView.this.invasionSpinner.setValue((Integer)DxView.this.invasionSpinner.getValue() + 5);
                }
            });
        }
        return this.invAdd5Button;
    }

    private JProgressBar getInvasionBar() {
        if (this.invasionBar == null) {
            this.invasionBar = new JProgressBar();
            this.invasionBar.setBorder(new SoftBevelBorder(1));
            this.invasionBar.setMaximum(180);
        }
        return this.invasionBar;
    }

    private JPanel getBonusPanel() {
        if (this.bonusPanel == null) {
            GridBagConstraints gridBagConstraints25 = new GridBagConstraints();
            gridBagConstraints25.fill = 1;
            gridBagConstraints25.gridy = 2;
            gridBagConstraints25.weightx = 1.0;
            gridBagConstraints25.gridx = 1;
            GridBagConstraints gridBagConstraints23 = new GridBagConstraints();
            gridBagConstraints23.gridx = 0;
            gridBagConstraints23.weightx = 0.0;
            gridBagConstraints23.gridy = 2;
            GridBagConstraints gridBagConstraints24 = new GridBagConstraints();
            gridBagConstraints24.fill = 1;
            gridBagConstraints24.gridy = 1;
            gridBagConstraints24.weightx = 1.0;
            gridBagConstraints24.insets = new Insets(0, 0, 2, 0);
            gridBagConstraints24.gridx = 1;
            GridBagConstraints gridBagConstraints22 = new GridBagConstraints();
            gridBagConstraints22.gridx = 0;
            gridBagConstraints22.gridy = 1;
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.fill = 1;
            gridBagConstraints21.gridy = 0;
            gridBagConstraints21.weightx = 1.0;
            gridBagConstraints21.insets = new Insets(0, 0, 2, 0);
            gridBagConstraints21.gridx = 1;
            GridBagConstraints gridBagConstraints26 = new GridBagConstraints();
            gridBagConstraints26.weightx = 0.0;
            this.jLabel6 = new JLabel();
            this.jLabel6.setText("\u30c0\u30a4\u30b9\u30dc\u30fc\u30ca\u30b9");
            this.bonusPanel = new JPanel();
            this.bonusPanel.setLayout(new GridBagLayout());
            this.bonusPanel.add((Component)this.jLabel6, gridBagConstraints26);
            this.bonusPanel.add((Component)this.getDiceBonusText(), gridBagConstraints21);
            this.bonusPanel.add((Component)this.jLabel7, gridBagConstraints22);
            this.bonusPanel.add((Component)this.getEfectLvText(), gridBagConstraints24);
            this.bonusPanel.add((Component)this.jLabel8, gridBagConstraints23);
            this.bonusPanel.add((Component)this.getTargetBonusText(), gridBagConstraints25);
        }
        return this.bonusPanel;
    }

    private JTextField getDiceBonusText() {
        if (this.diceBonusText == null) {
            this.diceBonusText = new JTextField();
            this.diceBonusText.setEditable(false);
            this.diceBonusText.setBackground(SystemColor.activeCaptionText);
        }
        return this.diceBonusText;
    }

    private JTextField getEfectLvText() {
        if (this.efectLvText == null) {
            this.efectLvText = new JTextField();
            this.efectLvText.setBackground(SystemColor.activeCaptionText);
            this.efectLvText.setEditable(false);
        }
        return this.efectLvText;
    }

    private JTextField getTargetBonusText() {
        if (this.targetBonusText == null) {
            this.targetBonusText = new JTextField();
            this.targetBonusText.setEditable(false);
            this.targetBonusText.setBackground(SystemColor.activeCaptionText);
        }
        return this.targetBonusText;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getLoisTable());
        }
        return this.jScrollPane;
    }

    private JTable getLoisTable() {
        if (this.loisTable == null) {
            this.loisTable = new JTable();
            this.loisTable.setModel(this.getLoisTableModel());
            TableColumnModel tcm = this.loisTable.getColumnModel();
            TableColumn column0 = tcm.getColumn(0);
            column0.setPreferredWidth(30);
            TableColumn column1 = tcm.getColumn(1);
            column1.setPreferredWidth(40);
            TableColumn column2 = tcm.getColumn(2);
            column2.setPreferredWidth(20);
            column2.setMaxWidth(20);
            TableColumn column3 = tcm.getColumn(3);
            column3.setPreferredWidth(30);
            TableColumn column4 = tcm.getColumn(4);
            column4.setPreferredWidth(20);
            column4.setMaxWidth(20);
            TableColumn column5 = tcm.getColumn(5);
            column5.setPreferredWidth(30);
            TableColumn column6 = tcm.getColumn(6);
            column6.setPreferredWidth(40);
            column6.setMaxWidth(40);
            TableColumn column7 = tcm.getColumn(7);
            column7.setPreferredWidth(40);
            column7.setMaxWidth(40);
        }
        return this.loisTable;
    }

    public LoisTableModel getLoisTableModel() {
        if (this.loisTableModel == null) {
            this.loisTableModel = new LoisTableModel();
            this.loisTableModel.addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent e) {
                    if (e.getColumn() == 0 || e.getColumn() == 6) {
                        DxView.this.actionMap.get("setStatus").actionPerformed(new ActionEvent(DxView.this.loisTableModel, 1001, "setStatus"));
                    }
                }
            });
        }
        return this.loisTableModel;
    }

    private JButton getHpAdd5Button() {
        if (this.hpAdd5Button == null) {
            this.hpAdd5Button = new JButton();
            this.hpAdd5Button.setText("-5");
            this.hpAdd5Button.setName("hpAdd5Button");
            this.hpAdd5Button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DxView.this.hpSpinner.setValue((Integer)DxView.this.hpSpinner.getValue() - 5);
                }
            });
        }
        return this.hpAdd5Button;
    }

    public String getPluginId() {
        return "jp.sf.chaplet.dx";
    }

    public String getPluginName() {
        return "\u30c0\u30d6\u30eb\u30af\u30ed\u30b9";
    }

    public JPanel getSwingComponent() {
        return this;
    }

    public void setController(ClientPlugin plugin) {
        ApplicationContext context = ApplicationContext.getInstance();
        this.actionMap = context.getActionMap((Object)plugin);
    }

    public void setGM(boolean gm) {
    }

    public void setLoginOK(boolean ok) {
        this.getRollButton().setEnabled(ok);
        this.getDamageButton().setEnabled(ok);
        this.getOneDiceButton().setEnabled(ok);
        this.getTwoDiceButton().setEnabled(ok);
    }

    public UniqueComboBoxModel<DiceRoll> getHistoryComboModel() {
        if (this.historyComboModel == null) {
            this.historyComboModel = new UniqueComboBoxModel();
        }
        return this.historyComboModel;
    }

    private JButton getClearButton() {
        if (this.clearButton == null) {
            this.clearButton = new JButton();
            this.clearButton.setText("\u30af\u30ea\u30a2");
            this.clearButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DxView.this.getHpSpinner().setValue(0);
                    DxView.this.getInvasionSpinner().setValue(0);
                    DxView.this.getLoisTableModel().clear();
                    System.out.println("actionPerformed()");
                }
            });
        }
        return this.clearButton;
    }

    private SpinnerNumberModel getInvasionModel() {
        if (this.invasionModel == null) {
            this.invasionModel = new SpinnerNumberModel();
            this.invasionModel.setMinimum(Integer.valueOf(0));
            this.invasionModel.setMaximum(Integer.valueOf(999));
        }
        return this.invasionModel;
    }
}

