/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.chaplet.dx.ui;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import jp.sf.chaplet.dx.Lois;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoisTableModel
extends AbstractTableModel {
    private static final String[] COLUMN_NAMES = new String[]{"\u95a2\u4fc2", "\u540d\u524d", "", "\u611f\u60c5(P)", "", "\u611f\u60c5(N)", "\uff80\uff72\uff80\uff7d", "\u6607\u83ef"};
    public static final int COLUMN_RELATION = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_POS_CHECK = 2;
    public static final int COLUMN_POS_FEELING = 3;
    public static final int COLUMN_NEG_CHECK = 4;
    public static final int COLUMN_NEG_FEELING = 5;
    public static final int COLUMN_TITUS = 6;
    public static final int COLUMN_SUBLIMATED = 7;
    private ArrayList<Lois> loisList = new ArrayList();

    public LoisTableModel() {
        this.loisList.add(new Lois());
        this.loisList.add(new Lois());
        this.loisList.add(new Lois());
        this.loisList.add(new Lois());
        this.loisList.add(new Lois());
        this.loisList.add(new Lois());
        this.loisList.add(new Lois());
    }

    public void setAll(ArrayList<Lois> list) {
        this.loisList.clear();
        this.loisList.addAll(list);
        this.fireTableDataChanged();
    }

    public ArrayList<Lois> getAll() {
        return this.loisList;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public int getRowCount() {
        return 7;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Lois lois = this.loisList.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return lois.getRelation();
            }
            case 1: {
                return lois.getName();
            }
            case 2: {
                if (lois.isPositive() && lois.isUsed()) {
                    return true;
                }
                return false;
            }
            case 3: {
                return lois.getPositiveFeeling();
            }
            case 4: {
                if (!lois.isPositive() && lois.isUsed()) {
                    return true;
                }
                return false;
            }
            case 5: {
                return lois.getNegativeFeeling();
            }
            case 6: {
                if (lois.isTitus() && lois.isUsed()) {
                    return true;
                }
                return false;
            }
            case 7: {
                if (lois.isSublimated() && lois.isUsed()) {
                    return true;
                }
                return false;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Lois lois = this.loisList.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                lois.setRelation((String)aValue);
                break;
            }
            case 1: {
                lois.setName((String)aValue);
                break;
            }
            case 2: {
                lois.setPositive((Boolean)aValue);
                this.fireTableCellUpdated(rowIndex, 4);
                break;
            }
            case 3: {
                lois.setPositiveFeeling((String)aValue);
                break;
            }
            case 4: {
                lois.setPositive((Boolean)aValue == false);
                this.fireTableCellUpdated(rowIndex, 2);
                break;
            }
            case 5: {
                lois.setNegativeFeeling((String)aValue);
                break;
            }
            case 6: {
                lois.setTitus((Boolean)aValue);
                break;
            }
            case 7: {
                lois.setSublimated((Boolean)aValue);
                if (!lois.isSublimated()) break;
                lois.setTitus(true);
                this.fireTableCellUpdated(rowIndex, 6);
            }
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                return Boolean.class;
            }
        }
        return super.getColumnClass(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    public int getNumLois() {
        int numLois = 0;
        for (Lois lois : this.loisList) {
            if (!lois.isUsed() || lois.isTitus()) continue;
            ++numLois;
        }
        return numLois;
    }

    public boolean isOrigin() {
        for (Lois lois : this.loisList) {
            if (!"\u8d77\u6e90\u7a2e".equals(lois.getName())) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        for (Lois lois : this.loisList) {
            lois.clear();
        }
        this.fireTableDataChanged();
    }
}

