/*
 * Decompiled with CFR 0.152.
 */
package application.extension;

import application.ApplicationContext;
import application.ResourceMap;
import application.TaskMonitor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Beans;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;

public class StatusBar
extends JPanel
implements PropertyChangeListener {
    private final Insets zeroInsets = new Insets(0, 0, 0, 0);
    private final JLabel messageLabel;
    private final JProgressBar progressBar;
    private final JLabel statusAnimationLabel;
    private final int messageTimeout;
    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private final int busyAnimationRate;
    private int busyIconIndex = 0;
    private TaskMonitor taskMonitor;

    public StatusBar() {
        super(new GridBagLayout());
        this.setBorder(new EmptyBorder(2, 0, 6, 0));
        this.messageLabel = new JLabel();
        this.progressBar = new JProgressBar(0, 100);
        this.statusAnimationLabel = new JLabel();
        if (Beans.isDesignTime()) {
            this.messageTimeout = 5000;
            this.messageTimer = new Timer(this.messageTimeout, new ClearOldMessage());
            this.messageTimer.setRepeats(false);
            this.busyAnimationRate = 30;
            this.idleIcon = null;
            this.busyIconTimer = new Timer(this.busyAnimationRate, new UpdateBusyIcon());
        } else {
            ApplicationContext appContext = ApplicationContext.getInstance();
            ResourceMap resourceMap = appContext.getResourceMap(StatusBar.class);
            this.messageTimeout = resourceMap.getInteger("messageTimeout");
            this.messageTimer = new Timer(this.messageTimeout, new ClearOldMessage());
            this.messageTimer.setRepeats(false);
            this.busyAnimationRate = resourceMap.getInteger("busyAnimationRate");
            this.idleIcon = resourceMap.getIcon("idleIcon");
            int i = 0;
            while (i < this.busyIcons.length) {
                this.busyIcons[i] = resourceMap.getIcon("busyIcons[" + i + "]");
                ++i;
            }
            this.busyIconTimer = new Timer(this.busyAnimationRate, new UpdateBusyIcon());
            this.progressBar.setEnabled(false);
            this.statusAnimationLabel.setIcon(this.idleIcon);
        }
        GridBagConstraints c = new GridBagConstraints();
        this.initGridBagConstraints(c);
        c.gridwidth = 0;
        c.fill = 2;
        c.weightx = 1.0;
        this.add((Component)new JSeparator(), c);
        this.initGridBagConstraints(c);
        c.insets = new Insets(6, 6, 0, 3);
        c.weightx = 1.0;
        c.fill = 2;
        this.add((Component)this.messageLabel, c);
        this.initGridBagConstraints(c);
        c.insets = new Insets(6, 3, 0, 3);
        this.add((Component)this.progressBar, c);
        this.initGridBagConstraints(c);
        c.insets = new Insets(6, 3, 0, 6);
        this.add((Component)this.statusAnimationLabel, c);
    }

    public void setMessage(String s) {
        this.messageLabel.setText(s == null ? "" : s);
        this.messageTimer.restart();
    }

    private void initGridBagConstraints(GridBagConstraints c) {
        c.anchor = 10;
        c.fill = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = -1;
        c.gridy = -1;
        c.insets = this.zeroInsets;
        c.ipadx = 0;
        c.ipady = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
    }

    public void showBusyAnimation() {
        if (!this.busyIconTimer.isRunning()) {
            this.statusAnimationLabel.setIcon(this.busyIcons[0]);
            this.busyIconIndex = 0;
            this.busyIconTimer.start();
        }
    }

    public void stopBusyAnimation() {
        this.busyIconTimer.stop();
        this.statusAnimationLabel.setIcon(this.idleIcon);
    }

    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        if ("started".equals(propertyName)) {
            this.showBusyAnimation();
            this.progressBar.setEnabled(true);
            this.progressBar.setIndeterminate(true);
        } else if ("done".equals(propertyName)) {
            this.stopBusyAnimation();
            this.progressBar.setEnabled(false);
            this.progressBar.setValue(0);
        } else if ("message".equals(propertyName)) {
            String text = (String)e.getNewValue();
            this.setMessage(text);
        } else if ("progress".equals(propertyName)) {
            int value = (Integer)e.getNewValue();
            this.progressBar.setEnabled(true);
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue(value);
        }
    }

    public TaskMonitor getTaskMonitor() {
        return this.taskMonitor;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        this.taskMonitor = taskMonitor;
        this.taskMonitor.addPropertyChangeListener((PropertyChangeListener)this);
    }

    private class ClearOldMessage
    implements ActionListener {
        private ClearOldMessage() {
        }

        public void actionPerformed(ActionEvent e) {
            StatusBar.this.messageLabel.setText("");
        }
    }

    private class UpdateBusyIcon
    implements ActionListener {
        private UpdateBusyIcon() {
        }

        public void actionPerformed(ActionEvent e) {
            StatusBar.this.busyIconIndex = (StatusBar.this.busyIconIndex + 1) % StatusBar.this.busyIcons.length;
            StatusBar.this.statusAnimationLabel.setIcon(StatusBar.this.busyIcons[StatusBar.this.busyIconIndex]);
        }
    }
}

