/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.chaplet;

import application.ApplicationContext;
import application.LocalStorage;
import java.beans.Beans;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StorageUtils {
    public static final String HANDLE = "handle.xml";
    public static final String PLUGIN = "plugin.xml";
    public static final String FONT = "font.xml";
    public static final String SERVER = "serverstat.xml";
    public static final String SESSION = "session.xml";
    private static String prefix = null;

    static {
        String workdir = System.getProperty("jp.sf.chaplet.workdir");
        if (workdir != null) {
            prefix = workdir.substring(workdir.lastIndexOf(File.separatorChar) + 1);
        }
    }

    public static final Object load(String name, Class theClass) {
        Object obj = StorageUtils.load(name);
        if (obj == null) {
            try {
                obj = Beans.instantiate(StorageUtils.class.getClassLoader(), theClass.getName());
            }
            catch (Exception e) {
                Logger.getLogger(StorageUtils.class.getName()).log(Level.SEVERE, e.getMessage(), e);
                return null;
            }
        }
        return obj;
    }

    static final Object load(String name) {
        LocalStorage localStorage = ApplicationContext.getInstance().getLocalStorage();
        try {
            return localStorage.load(prefix == null ? name : String.valueOf(prefix) + "-" + name);
        }
        catch (IOException e) {
            Logger.getLogger(StorageUtils.class.getName()).log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    public static final void save(Object bean, String name) {
        LocalStorage localStorage = ApplicationContext.getInstance().getLocalStorage();
        try {
            localStorage.save(bean, prefix == null ? name : String.valueOf(prefix) + "-" + name);
        }
        catch (IOException e) {
            Logger.getLogger(StorageUtils.class.getName()).log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public static final HashMap<String, Object> getFontMap() {
        HashMap<String, Object> fontMap = null;
        fontMap = (HashMap<String, Object>)StorageUtils.load(FONT);
        if (fontMap == null) {
            fontMap = new HashMap<String, Object>();
            fontMap.put("fontName", "\uff2d\uff33 \u30b4\u30b7\u30c3\u30af");
            fontMap.put("fontSize", 12);
            fontMap.put("systemColor", "990000");
            fontMap.put("normalColor", "000000");
        }
        return fontMap;
    }
}

