/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.chaplet.core.server;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.sf.chaplet.ActionResult;
import jp.sf.chaplet.ConfigLoader;
import jp.sf.chaplet.Configuration;
import jp.sf.chaplet.Plugin;
import jp.sf.chaplet.StorageUtils;
import jp.sf.chaplet.core.server.ActivatePluginAction;
import jp.sf.chaplet.core.server.ChatServerAction;
import jp.sf.chaplet.core.server.ClientProxy;
import jp.sf.chaplet.core.server.IServerListener;
import jp.sf.chaplet.core.server.LoginServerAction;
import jp.sf.chaplet.core.server.LogoutServerAction;
import jp.sf.chaplet.core.server.RollAction;
import jp.sf.chaplet.core.server.ServerAction;
import jp.sf.chaplet.core.server.ServerPlugin;
import jp.sf.chaplet.core.server.SetGMAction;
import jp.sf.chaplet.core.server.StatusAction;
import jp.sf.chaplet.core.server.User;
import jp.sf.chaplet.core.server.UserManager;
import jp.sf.chaplet.core.server.WritingServerAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChatServer
extends ServerPlugin {
    private UserManager userManager = new UserManager();
    private ArrayList<ClientProxy> proxyList = new ArrayList();
    private ServerSocket serverSocket;
    private ArrayList<IServerListener> listenerList = new ArrayList();
    private ServerPlugin primaryPlugin;
    private Logger logger = Logger.getLogger(ChatServer.class.getName());
    private TreeMap<String, ServerPlugin> pluginMap = new TreeMap();
    private String owner;

    public static void main(String[] args) {
        try {
            ChatServer server = new ChatServer("RL");
            server.init();
            server.loop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ChatServer(String masterName) {
        this.owner = masterName;
        this.userManager.setMasterId(masterName);
        this.server = this;
    }

    @Override
    public void init() throws Exception {
        Configuration conf = ConfigLoader.getInstance().load();
        for (Plugin plugin : conf.getPlugins()) {
            try {
                ServerPlugin serverPlugin = plugin.getServerPlugin();
                serverPlugin.init(this);
                this.addPlugin(serverPlugin);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, plugin.getPluginId(), e);
            }
        }
        ServerAction[] actions = new ServerAction[]{new LoginServerAction(), new LogoutServerAction(), new ChatServerAction(), new WritingServerAction(), new ActivatePluginAction(), new SetGMAction(), new StatusAction(), new RollAction()};
        int i = 0;
        while (i < actions.length) {
            actions[i].init(this, this);
            ++i;
        }
        this.addAction("login", actions[0]);
        this.addAction("logout", actions[1]);
        this.addAction("chat", actions[2]);
        this.addAction("writing", actions[3]);
        this.addAction("activateplugin", actions[4]);
        this.addAction("setgm", actions[5]);
        this.addAction("status", actions[6]);
        this.addAction("roll", actions[7]);
        this.setPrimaryPlugin(conf.getPrimaryPluginId());
    }

    public void loop() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                Socket socket = null;
                Configuration conf = ConfigLoader.getInstance().load();
                try {
                    ChatServer.this.serverSocket = new ServerSocket();
                    InetSocketAddress address = new InetSocketAddress(conf.getPort());
                    ChatServer.this.serverSocket.bind(address);
                    ChatServer.this.notifyServerStarted();
                }
                catch (BindException e) {
                    ChatServer.this.notifyFailedToStartServer();
                    return;
                }
                catch (IOException e) {
                    ChatServer.this.logger.log(Level.SEVERE, "loop", e);
                    ChatServer.this.notifyErrorOccured();
                    return;
                }
                try {
                    while (true) {
                        socket = ChatServer.this.serverSocket.accept();
                        ClientProxy proxy = new ClientProxy();
                        proxy.init(ChatServer.this, socket);
                        ChatServer.this.addProxy(proxy);
                        proxy.start();
                    }
                }
                catch (BindException e) {
                    ChatServer.this.logger.log(Level.SEVERE, "bind", e);
                    ChatServer.this.notifyErrorOccured();
                }
                catch (SocketException e) {
                    if (e.getMessage().equalsIgnoreCase("socket closed")) {
                        ChatServer.this.notifyServerStopped();
                    } else {
                        ChatServer.this.logger.log(Level.SEVERE, "loop", e);
                    }
                    try {
                        socket.close();
                        ChatServer.this.serverSocket.close();
                    }
                    catch (IOException e1) {
                        ChatServer.this.logger.log(Level.FINE, "loop", e);
                    }
                }
                catch (IOException e) {
                    ChatServer.this.logger.log(Level.SEVERE, "loop", e);
                    ChatServer.this.notifyErrorOccured();
                }
            }
        }, "server-loop");
        thread.start();
    }

    public void sendLog(String[] logs) {
        this.sendLog(logs, null);
    }

    public void sendLog(String[] logs, ClientProxy proxy) {
        ClientProxy[] proxies = this.proxyList.toArray(new ClientProxy[this.proxyList.size()]);
        int i = 0;
        while (i < proxies.length) {
            if (proxy == null || proxy != proxies[i]) {
                proxies[i].sendMessage(logs);
            }
            ++i;
        }
    }

    public void sendStatus(ClientProxy proxy) {
        User[] users = this.userManager.getAllUsers();
        String[] message = new String[users.length * 4 + 1];
        message[0] = "status";
        int i = 0;
        while (i < users.length) {
            message[i * 4 + 1] = users[i].getDisplayName();
            message[i * 4 + 2] = users[i].isWriting() ? "y" : (users[i].isAlive() ? "n" : "-");
            message[i * 4 + 3] = users[i].getSessionId();
            if (this.primaryPlugin != null) {
                message[i * 4 + 4] = this.primaryPlugin.getUserStatus(users[i]);
                if (message[i * 4 + 4] == null || message[i * 3 + 3].length() == 0) {
                    message[i * 4 + 4] = " ";
                }
            }
            ++i;
        }
        proxy.sendMessage(message);
    }

    public void sendStatus() {
        ClientProxy[] proxies = this.proxyList.toArray(new ClientProxy[this.proxyList.size()]);
        int i = 0;
        while (i < proxies.length) {
            this.sendStatus(proxies[i]);
            ++i;
        }
    }

    public boolean addProxy(ClientProxy proxy) {
        return this.proxyList.add(proxy);
    }

    public boolean removeProxy(ClientProxy proxy, boolean isAccident) {
        if (this.proxyList.remove(proxy)) {
            this.userManager.logout(proxy.getSessionId(), isAccident);
            this.sendStatus();
            return true;
        }
        return false;
    }

    public Iterator<ClientProxy> getProxyIterator() {
        return this.proxyList.iterator();
    }

    public boolean execute(ClientProxy proxy, String[] lines) throws IOException {
        try {
            ServerAction command = this.getAction(lines[0]);
            ServerAction pluginCommand = this.getPluginAction(lines[0]);
            ActionResult result = ActionResult.NULL;
            if (pluginCommand != null) {
                result = pluginCommand.getExecutionTime().execute(command, pluginCommand, lines, proxy);
            } else if (command != null) {
                result = command.execute(lines, proxy);
            }
            if (result == ActionResult.DISCONNECT) {
                this.proxyList.remove(proxy);
                this.userManager.logout(proxy.getSessionId(), false);
                proxy.sendDisconnect();
                this.sendLog(lines);
                this.sendStatus();
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "execute", e);
            this.notifyErrorOccured();
            return true;
        }
    }

    public ClientProxy getProxy(String name) {
        for (ClientProxy proxy : this.proxyList) {
            if (!proxy.getSessionId().equals(name)) continue;
            return proxy;
        }
        return null;
    }

    public void stop() {
        ClientProxy[] proxies = this.proxyList.toArray(new ClientProxy[this.proxyList.size()]);
        int i = 0;
        while (i < proxies.length) {
            proxies[i].sendDisconnect();
            ++i;
        }
        Thread thread = new Thread(new Runnable(){

            public void run() {
                while (ChatServer.this.proxyList.size() > 0) {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                try {
                    ChatServer.this.serverSocket.close();
                }
                catch (IOException e) {
                    ChatServer.this.logger.log(Level.SEVERE, "server socket close", e);
                }
            }
        }, "server-waitToDestroyProxies");
        thread.start();
    }

    public boolean addServerListener(IServerListener listener) {
        return this.listenerList.add(listener);
    }

    public boolean removeServerListener(IServerListener listener) {
        return this.listenerList.remove(listener);
    }

    private void notifyServerStarted() {
        for (IServerListener listener : this.listenerList) {
            listener.serverStarted();
        }
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public ServerPlugin getPrimaryPlugin() {
        return this.primaryPlugin;
    }

    public boolean setPrimaryPlugin(String pluginId) {
        if (pluginId == null) {
            this.primaryPlugin = null;
            return true;
        }
        ServerPlugin plugin = this.getPlugin(pluginId);
        if (plugin != null) {
            this.primaryPlugin = plugin;
            return true;
        }
        return false;
    }

    public void save() {
        HashMap map = new HashMap();
        HashMap<String, User[]> coreMap = new HashMap<String, User[]>();
        coreMap.put("users", this.userManager.getAllUsers());
        map.put("core", coreMap);
        for (String key : this.pluginMap.keySet()) {
            ServerPlugin plugin = this.pluginMap.get(key);
            HashMap<String, Object> values = new HashMap<String, Object>();
            plugin.save(values);
            if (values.size() <= 0) continue;
            map.put(plugin.getPluginId(), values);
        }
        StorageUtils.save(map, "serverstat.xml");
    }

    public void load() {
        HashMap map = (HashMap)StorageUtils.load("serverstat.xml", HashMap.class);
        HashMap coreMap = (HashMap)map.get("core");
        this.userManager.setAllUsers((User[])coreMap.get("users"));
        for (String key : this.pluginMap.keySet()) {
            ServerPlugin plugin = this.pluginMap.get(key);
            HashMap values = (HashMap)map.get(key);
            plugin.load(values);
        }
        this.sendStatus();
        if (this.primaryPlugin != null) {
            Iterator<ClientProxy> iter = this.getProxyIterator();
            while (iter.hasNext()) {
                ClientProxy proxy = iter.next();
                this.primaryPlugin.sendPluginStatus(proxy);
            }
            this.primaryPlugin.sendPluginStatus();
        }
    }

    public void addPlugin(ServerPlugin newPlugin) {
        this.pluginMap.put(newPlugin.getPluginId(), newPlugin);
    }

    public ServerPlugin getPlugin(String name) {
        return this.pluginMap.get(name);
    }

    @Override
    public String getPluginId() {
        return "jp.sf.chaplet.core";
    }

    public ServerAction getPluginAction(String actionName) {
        ServerAction action;
        if (this.primaryPlugin != null && (action = this.primaryPlugin.getAction(actionName)) != null) {
            return action;
        }
        for (String key : this.pluginMap.keySet()) {
            ServerPlugin plugin = this.pluginMap.get(key);
            ServerAction action2 = plugin.getAction(actionName);
            if (action2 == null) continue;
            return action2;
        }
        return null;
    }

    private void notifyServerStopped() {
        for (IServerListener listener : this.listenerList) {
            listener.serverStopped();
        }
    }

    private void notifyErrorOccured() {
        for (IServerListener listener : this.listenerList) {
            listener.errorOccured();
        }
    }

    private void notifyFailedToStartServer() {
        for (IServerListener listener : this.listenerList) {
            listener.failedToStartServer();
        }
    }

    @Override
    public void reload() throws Exception {
        for (String key : this.pluginMap.keySet()) {
            ServerPlugin plugin = this.pluginMap.get(key);
            plugin.reload();
        }
    }

    public String getOwner() {
        return this.owner;
    }

    public Iterator<ServerPlugin> getPluginIterator() {
        return this.pluginMap.values().iterator();
    }
}

