/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.chaplet.core.server;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.sf.chaplet.NetUtil;
import jp.sf.chaplet.core.server.ChatServer;

public class ClientProxy {
    private ChatServer server;
    private Socket socket;
    private LinkedList<String[]> messageQueue = new LinkedList();
    private BufferedWriter writer;
    private BufferedReader reader;
    private String sessionId;
    private Logger logger = Logger.getLogger(ClientProxy.class.getName());
    private Thread mainThread;

    public void init(ChatServer server, Socket socket) throws IOException {
        this.server = server;
        this.socket = socket;
        this.writer = NetUtil.getWriter(socket);
        this.reader = NetUtil.getReader(socket);
    }

    public void start() {
        this.mainThread = new Thread(new Runnable(){

            public void run() {
                ClientProxy.this.messageLoop();
            }
        }, "server-messageLoop");
        Thread recieveThread = new Thread(new Runnable(){

            public void run() {
                ClientProxy.this.recieveLoop();
            }
        }, "server-recieveLoop");
        this.mainThread.start();
        recieveThread.start();
    }

    public void sendDisconnect() {
        this.sendMessage(new String[]{"disconnect"});
    }

    public synchronized void destroy() throws IOException {
        try {
            this.socket.shutdownInput();
            this.socket.shutdownOutput();
            this.reader.read();
            this.reader.close();
            this.writer.close();
            this.mainThread.interrupt();
        }
        finally {
            this.socket.close();
        }
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String name) {
        this.sessionId = name;
    }

    public synchronized void sendMessage(String[] message) {
        this.messageQueue.addLast(message);
        this.notifyAll();
    }

    private void recieveLoop() {
        block6: {
            block5: {
                try {
                    String[] line;
                    while ((line = NetUtil.getRequest(this.reader)) != null && line.length != 0) {
                        this.server.execute(this, line);
                    }
                }
                catch (Exception e) {
                    if (e instanceof SocketException && (e.getMessage().equals("socket closed") || e.getMessage().equals("Connection reset"))) break block5;
                    this.logger.log(Level.SEVERE, "recieveLoop", e);
                }
            }
            this.server.removeProxy(this, true);
            try {
                this.destroy();
            }
            catch (IOException e) {
                if (e.getMessage().equals("Socket is closed")) break block6;
                this.logger.log(Level.SEVERE, "recieveLoop", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void messageLoop() {
        while (true) {
            String[] request = null;
            ClientProxy clientProxy = this;
            synchronized (clientProxy) {
                while (this.messageQueue.size() == 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                if (this.messageQueue.size() == 0) {
                    return;
                }
                request = this.messageQueue.removeFirst();
                this.notifyAll();
            }
            try {
                int i = 0;
                while (i < request.length) {
                    NetUtil.writeLine(this.writer, request[i]);
                    ++i;
                }
                this.writer.write(46);
                this.writer.newLine();
                this.writer.flush();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, request[0], e);
                this.server.removeProxy(this, true);
                return;
            }
        }
    }
}

