/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.AbstractBean;
import application.Application;
import application.ApplicationContext;
import application.ResourceMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceManager
extends AbstractBean {
    private static final Logger logger = Logger.getLogger(ResourceManager.class.getName());
    private final Map<String, ResourceMap> resourceMaps = new ConcurrentHashMap<String, ResourceMap>();
    private List<String> applicationBundleNames = null;
    private ResourceMap appResourceMap = null;

    protected ResourceManager() {
    }

    private List<String> allBundleNames(Class startClass, Class stopClass) {
        ArrayList<String> bundleNames = new ArrayList<String>();
        Class limitClass = stopClass.getSuperclass();
        for (Class c = startClass; c != limitClass; c = c.getSuperclass()) {
            bundleNames.addAll(this.getClassBundleNames(c));
        }
        return Collections.unmodifiableList(bundleNames);
    }

    private String bundlePackageName(String bundleName) {
        int i = bundleName.lastIndexOf(".");
        return i == -1 ? "" : bundleName.substring(0, i);
    }

    private ResourceMap createResourceMapChain(ClassLoader cl, ResourceMap root, ListIterator<String> names) {
        if (!names.hasNext()) {
            return root;
        }
        String bundleName0 = names.next();
        String rmBundlePackage = this.bundlePackageName(bundleName0);
        ArrayList<String> rmNames = new ArrayList<String>();
        rmNames.add(bundleName0);
        while (names.hasNext()) {
            String bundleName = names.next();
            if (rmBundlePackage.equals(this.bundlePackageName(bundleName))) {
                rmNames.add(bundleName);
                continue;
            }
            names.previous();
            break;
        }
        ResourceMap parent = this.createResourceMapChain(cl, root, names);
        return this.createResourceMap(cl, parent, rmNames);
    }

    private ResourceMap getApplicationResourceMap() {
        if (this.appResourceMap == null) {
            List<String> appBundleNames = this.getApplicationBundleNames();
            Class<Application> appClass = ApplicationContext.getInstance().getApplicationClass();
            if (appClass == null) {
                logger.warning("getApplicationResourceMap(): no Application class");
                appClass = Application.class;
            }
            ClassLoader classLoader = appClass.getClassLoader();
            this.appResourceMap = this.createResourceMapChain(classLoader, null, appBundleNames.listIterator());
        }
        return this.appResourceMap;
    }

    private ResourceMap getClassResourceMap(Class startClass, Class stopClass) {
        String classResourceMapKey = startClass.getName() + stopClass.getName();
        ResourceMap classResourceMap = this.resourceMaps.get(classResourceMapKey);
        if (classResourceMap == null) {
            List<String> classBundleNames = this.allBundleNames(startClass, stopClass);
            ClassLoader classLoader = startClass.getClassLoader();
            ResourceMap appRM = this.getResourceMap();
            classResourceMap = this.createResourceMapChain(classLoader, appRM, classBundleNames.listIterator());
            this.resourceMaps.put(classResourceMapKey, classResourceMap);
        }
        return classResourceMap;
    }

    public ResourceMap getResourceMap(Class startClass, Class stopClass) {
        if (startClass == null) {
            throw new IllegalArgumentException("null startClass");
        }
        if (stopClass == null) {
            throw new IllegalArgumentException("null stopClass");
        }
        if (!stopClass.isAssignableFrom(startClass)) {
            throw new IllegalArgumentException("startClass is not a subclass, or the same as, stopClass");
        }
        return this.getClassResourceMap(startClass, stopClass);
    }

    public final ResourceMap getResourceMap(Class cls) {
        if (cls == null) {
            throw new IllegalArgumentException("null class");
        }
        return this.getResourceMap(cls, cls);
    }

    public ResourceMap getResourceMap() {
        return this.getApplicationResourceMap();
    }

    public List<String> getApplicationBundleNames() {
        if (this.applicationBundleNames == null) {
            Class appClass = ApplicationContext.getInstance().getApplicationClass();
            if (appClass == null) {
                return this.allBundleNames(Application.class, Application.class);
            }
            this.applicationBundleNames = this.allBundleNames(appClass, Application.class);
        }
        return this.applicationBundleNames;
    }

    public void setApplicationBundleNames(List<String> bundleNames) {
        if (bundleNames != null) {
            for (String bundleName : bundleNames) {
                if (bundleName != null && bundleNames.size() != 0) continue;
                throw new IllegalArgumentException("invalid bundle name \"" + bundleName + "\"");
            }
        }
        List<String> oldValue = this.applicationBundleNames;
        this.applicationBundleNames = bundleNames != null ? Collections.unmodifiableList(new ArrayList<String>(bundleNames)) : null;
        this.resourceMaps.clear();
        this.firePropertyChange("applicationBundleNames", oldValue, this.applicationBundleNames);
    }

    private String classBundleBaseName(Class cls) {
        String className = cls.getName();
        StringBuffer sb = new StringBuffer();
        int i = className.lastIndexOf(46);
        if (i > 0) {
            sb.append(className.substring(0, i));
            sb.append(".resources.");
            sb.append(cls.getSimpleName());
        } else {
            sb.append("resources.");
            sb.append(cls.getSimpleName());
        }
        return sb.toString();
    }

    protected List<String> getClassBundleNames(Class cls) {
        String bundleName = this.classBundleBaseName(cls);
        return Collections.singletonList(bundleName);
    }

    protected ResourceMap createResourceMap(ClassLoader classLoader, ResourceMap parent, List<String> bundleNames) {
        return new ResourceMap(parent, classLoader, bundleNames);
    }

    public String getPlatform() {
        return this.getResourceMap().getString("platform", new Object[0]);
    }

    public void setPlatform(String platform) {
        if (platform == null) {
            throw new IllegalArgumentException("null platform");
        }
        this.getResourceMap().putResource("platform", platform);
    }
}

