/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.chaplet.nova.client;

import application.Action;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jp.sf.chaplet.UserStatus;
import jp.sf.chaplet.core.client.ClientPlugin;
import jp.sf.chaplet.core.ui.IPluginView;
import jp.sf.chaplet.core.ui.IPrefView;
import jp.sf.chaplet.nova.Card;
import jp.sf.chaplet.nova.Plot;
import jp.sf.chaplet.nova.PlotChara;
import jp.sf.chaplet.nova.client.AddCharacterAction;
import jp.sf.chaplet.nova.client.FeedAction;
import jp.sf.chaplet.nova.client.GiveCardAction;
import jp.sf.chaplet.nova.client.HandToPileAction;
import jp.sf.chaplet.nova.client.PlotToHandAction;
import jp.sf.chaplet.nova.client.PlotToPileAction;
import jp.sf.chaplet.nova.client.ReactionAction;
import jp.sf.chaplet.nova.client.RemoveCharacterAction;
import jp.sf.chaplet.nova.client.SceneAction;
import jp.sf.chaplet.nova.client.SetStatusAction;
import jp.sf.chaplet.nova.client.ShowPlotAction;
import jp.sf.chaplet.nova.client.ToPlotAction;
import jp.sf.chaplet.nova.client.YamabikiAction;
import jp.sf.chaplet.nova.ui.BasicPrefPanel;
import jp.sf.chaplet.nova.ui.INovaView;
import jp.sf.chaplet.nova.ui.NovaView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NovaClientPlugin
extends ClientPlugin {
    private NovaView view;

    protected void startup() {
        this.addAction("nova:addchara", new AddCharacterAction());
        this.addAction("nova:feed", new FeedAction());
        this.addAction("nova:handtopile", new HandToPileAction());
        this.addAction("nova:plottopile", new PlotToPileAction());
        this.addAction("nova:reaction", new ReactionAction());
        this.addAction("nova:delchara", new RemoveCharacterAction());
        this.addAction("nova:scene", new SceneAction());
        this.addAction("nova:toplot", new ToPlotAction());
        this.addAction("nova:yamabiki", new YamabikiAction());
        this.addAction("nova:status", new SetStatusAction());
        this.addAction("nova:givecard", new GiveCardAction());
        this.addAction("nova:tohand", new PlotToHandAction());
        this.addAction("nova:showplot", new ShowPlotAction());
        this.view = new NovaView();
        this.view.setController(this);
    }

    public INovaView getNovaView() {
        return this.view;
    }

    @Action
    public void feedHand() {
        this.getConnection().sendMessage(new String[]{"nova:feed"});
    }

    @Action
    public void handToPile() {
        Card card = (Card)this.view.getHandList().getSelectedValue();
        if (card == null) {
            return;
        }
        String[] message = new String[]{"nova:handtopile", card.toString()};
        this.getConnection().sendMessage(message);
    }

    @Action
    public void nextScene() {
        this.getConnection().sendMessage(new String[]{"nova:scene"});
    }

    @Action
    public void addCharacter() {
        this.getConnection().sendMessage(new String[]{"nova:addchara"});
    }

    @Action
    public void removeCharacter() {
        int rowIndex = this.view.getPlotTable().getSelectedRow();
        if (rowIndex < 0) {
            return;
        }
        PlotChara chara = this.view.getPlotTableModel().indexOf(rowIndex);
        if (chara != null) {
            this.getConnection().sendMessage(new String[]{"nova:delchara", String.valueOf(chara.getCharaNo())});
        }
    }

    @Action
    public void yamabiki() {
        this.getConnection().sendMessage(new String[]{"nova:yamabiki"});
    }

    @Action
    public void handToProt() {
        Card card = (Card)this.view.getHandList().getSelectedValue();
        if (card == null) {
            return;
        }
        int rowIndex = this.view.getPlotTable().getSelectedRow();
        if (rowIndex < 0) {
            rowIndex = 0;
        }
        if (this.view.getPlotTable().getRowCount() < rowIndex) {
            return;
        }
        PlotChara chara = this.view.getPlotTableModel().indexOf(rowIndex);
        if (chara != null) {
            this.getConnection().sendMessage(new String[]{"nova:toplot", String.valueOf(chara.getCharaNo()), card.toString()});
        }
    }

    @Action
    public void plotToPile() {
        int rowIndex = this.view.getPlotTable().getSelectedRow();
        if (rowIndex < 0) {
            rowIndex = 0;
        }
        if (this.view.getPlotTable().getRowCount() < rowIndex) {
            return;
        }
        PlotChara chara = this.view.getPlotTableModel().indexOf(rowIndex);
        int columnIndex = this.view.getPlotTable().getSelectedColumn();
        if (columnIndex <= 0) {
            return;
        }
        Plot plot = this.view.getPlotTableModel().getPlot(chara.getCharaNo(), columnIndex - 1);
        if (plot != null) {
            String[] message = new String[]{"nova:plottopile", String.valueOf(chara.getCharaNo()), plot.getCard().toString()};
            this.getConnection().sendMessage(message);
        }
    }

    @Action
    public void plotToHand() {
        int rowIndex = this.view.getPlotTable().getSelectedRow();
        if (rowIndex < 0) {
            rowIndex = 0;
        }
        if (this.view.getPlotTable().getRowCount() < rowIndex) {
            return;
        }
        PlotChara chara = this.view.getPlotTableModel().indexOf(rowIndex);
        int columnIndex = this.view.getPlotTable().getSelectedColumn();
        if (columnIndex <= 0) {
            return;
        }
        Plot plot = this.view.getPlotTableModel().getPlot(chara.getCharaNo(), columnIndex - 1);
        if (plot != null) {
            String[] message = new String[]{"nova:tohand", String.valueOf(chara.getCharaNo()), plot.getCard().toString()};
            this.getConnection().sendMessage(message);
        }
    }

    @Action
    public void toReaction() {
        int rowIndex = this.view.getPlotTable().getSelectedRow();
        if (rowIndex < 0) {
            rowIndex = 0;
        }
        if (this.view.getPlotTable().getRowCount() < rowIndex) {
            return;
        }
        PlotChara chara = this.view.getPlotTableModel().indexOf(rowIndex);
        int columnIndex = this.view.getPlotTable().getSelectedColumn();
        if (columnIndex <= 0) {
            return;
        }
        Plot plot = this.view.getPlotTableModel().getPlot(chara.getCharaNo(), columnIndex - 1);
        this.getConnection().sendMessage(new String[]{"nova:reaction", String.valueOf(chara.getCharaNo()), plot.getCard().toString(), plot.isReaction() ? "|" : "_"});
    }

    @Action
    public void initServer() {
        this.getConnection().sendMessage(new String[]{"nova:init"});
    }

    public IPluginView getPluginView() {
        return this.view;
    }

    public String getPluginId() {
        return "jp.sf.chaplet.nova";
    }

    public JPanel getSwingComponent() {
        return this.view;
    }

    public List<IPrefView> getPrefViewList() {
        ArrayList<IPrefView> prefList = new ArrayList<IPrefView>();
        prefList.add(new BasicPrefPanel());
        return prefList;
    }

    @Action
    public void giveCard() {
        Card card = (Card)this.view.getHandList().getSelectedValue();
        if (card == null) {
            return;
        }
        Object[] users = this.getController().getUsers();
        UserStatus user = (UserStatus)JOptionPane.showInputDialog((Component)this.getController().getView(), "\u30ab\u30fc\u30c9\u3092\u6e21\u3059\u30e6\u30fc\u30b6\u3092\u9078\u629e\u3057\u3066\u4e0b\u3055\u3044\u3002", "\u30e6\u30fc\u30b6\u306e\u9078\u629e", 2, null, users, null);
        if (user != null) {
            this.getConnection().sendMessage(new String[]{"nova:givecard", user.getSessionId(), card.toString()});
        }
    }

    @Action
    public void showPlot() {
        int rowIndex = this.view.getPlotTable().getSelectedRow();
        if (rowIndex < 0) {
            rowIndex = 0;
        }
        if (this.view.getPlotTable().getRowCount() < rowIndex) {
            return;
        }
        PlotChara chara = this.view.getPlotTableModel().indexOf(rowIndex);
        int columnIndex = this.view.getPlotTable().getSelectedColumn();
        if (columnIndex <= 0) {
            return;
        }
        Plot plot = this.view.getPlotTableModel().getPlot(chara.getCharaNo(), columnIndex - 1);
        if (plot != null) {
            this.getConnection().sendMessage(new String[]{"nova:showplot", plot.getCard().toString()});
        }
    }
}

