/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.chaplet.nova.server;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CardManager {
    private int numJoker = 2;
    private int numDeck = 2;
    private int numAvailable;
    private String file;
    private ArrayList<StringBuffer> cardList = new ArrayList();

    public void setProperties(Map<String, Object> map) {
        int i = 0;
        int n = this.cardList.size();
        while (i < n) {
            StringBuffer element = this.cardList.get(i);
            map.put("card.1", element.toString());
            ++i;
        }
    }

    public void getProperties(Map<String, Object> map) {
        this.cardList.clear();
        this.numAvailable = 0;
        this.numJoker = 0;
        this.numDeck = 0;
        for (String key : map.keySet()) {
            if (!key.startsWith("card.")) continue;
            String element = (String)map.get(key);
            this.cardList.add(new StringBuffer(element));
            int j = 0;
            while (j < element.length()) {
                if (element.charAt(j) == '0') {
                    ++this.numAvailable;
                }
                ++j;
            }
        }
        this.numDeck = this.cardList.size() / 4;
        if (this.cardList.size() % 4 > 0) {
            this.numJoker = this.cardList.get(this.cardList.size() - 1).length();
        }
    }

    public void load() throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(this.file));
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                if (line.length() <= 0 || line.startsWith("#")) continue;
                this.cardList.add(new StringBuffer(line));
                int i = 0;
                while (i < line.length()) {
                    if (line.charAt(i) == '0') {
                        ++this.numAvailable;
                    }
                    ++i;
                }
            }
            this.numJoker = this.cardList.get(this.cardList.size() - 1).length();
            this.numDeck = (this.cardList.size() - 1) / 4;
        }
        finally {
            reader.close();
        }
    }

    public void init() {
        this.reset();
    }

    public void reset() {
        int i;
        this.cardList.clear();
        int j = 0;
        while (j < this.numDeck) {
            i = 0;
            while (i < 4) {
                String line = "0000000000000";
                this.cardList.add(new StringBuffer(line));
                ++i;
            }
            ++j;
        }
        StringBuffer line = new StringBuffer();
        i = 0;
        while (i < this.numJoker) {
            line.append('0');
            ++i;
        }
        this.cardList.add(line);
        this.numAvailable = this.numDeck * 4 * 13 + this.numJoker;
    }

    int getNextCard(StringBuffer line, int order) {
        int n = -1;
        int i = 0;
        while (i < line.length()) {
            if (line.charAt(i) == '0') {
                if (order <= 0) {
                    return i;
                }
                --order;
                --n;
            }
            ++i;
        }
        return n;
    }

    public String next() throws IOException {
        int order = this.getNextOrder();
        int suiteNo = 0;
        int cardNo = 0;
        StringBuffer line = null;
        while (suiteNo < this.cardList.size()) {
            line = this.cardList.get(suiteNo);
            cardNo = this.getNextCard(line, order);
            if (cardNo >= 0) break;
            order += cardNo + 1;
            ++suiteNo;
        }
        if (suiteNo >= this.cardList.size()) {
            this.reset();
            return this.next();
        }
        String card = null;
        if (suiteNo == this.cardList.size() - 1) {
            card = "JK";
        } else {
            switch (suiteNo % 4) {
                case 0: {
                    card = "S";
                    break;
                }
                case 1: {
                    card = "C";
                    break;
                }
                case 2: {
                    card = "H";
                    break;
                }
                case 3: {
                    card = "D";
                }
            }
            card = cardNo == 0 ? String.valueOf(card) + "A" : (cardNo == 9 ? String.valueOf(card) + "T" : (cardNo == 10 ? String.valueOf(card) + "J" : (cardNo == 11 ? String.valueOf(card) + "Q" : (cardNo == 12 ? String.valueOf(card) + "K" : String.valueOf(card) + (cardNo + 1)))));
        }
        line.setCharAt(cardNo, '1');
        this.cardList.set(suiteNo, line);
        --this.numAvailable;
        if (this.numAvailable <= 0) {
            this.reset();
        }
        return card;
    }

    public void setThrownAway(ArrayList<String> cards) {
        for (String card : cards) {
            this.setThrownAway(card);
        }
    }

    public void setThrownAway(String[] cards) {
        int i = 0;
        while (i < cards.length) {
            this.setThrownAway(cards[i]);
            ++i;
        }
    }

    public void setThrownAway(String card) {
        int suite = 4;
        int num = 0;
        if (!card.equals("JK")) {
            switch (card.charAt(0)) {
                case 'S': {
                    suite = 0;
                    break;
                }
                case 'C': {
                    suite = 1;
                    break;
                }
                case 'H': {
                    suite = 2;
                    break;
                }
                case 'D': {
                    suite = 3;
                }
            }
            switch (card.charAt(1)) {
                case 'A': {
                    num = 0;
                    break;
                }
                case 'T': {
                    num = 9;
                    break;
                }
                case 'K': {
                    num = 12;
                    break;
                }
                case 'Q': {
                    num = 11;
                    break;
                }
                case 'J': {
                    num = 10;
                    break;
                }
                default: {
                    num = card.charAt(1) - 49;
                }
            }
        }
        int i = 0;
        while (i < this.cardList.size()) {
            StringBuffer cards = this.cardList.get(suite + i);
            if (cards.charAt(num) == '1') {
                cards.setCharAt(num, '2');
            }
            i += 5;
        }
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getFile() {
        return this.file;
    }

    int count() {
        return this.cardList.size();
    }

    public int getNumDeck() {
        return this.numDeck;
    }

    public void setNumDeck(int numDeck) {
        this.numDeck = numDeck;
    }

    public int getNumJoker() {
        return this.numJoker;
    }

    public void setNumJoker(int numJoker) {
        this.numJoker = numJoker;
    }

    int getNextOrder() {
        return (int)(Math.random() * (double)this.numAvailable);
    }

    public int getNumAvailable() {
        return this.numAvailable;
    }
}

