/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.chaplet.nova.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jp.sf.chaplet.nova.NovaConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TarotManager {
    private static final String DEFAULT_FILE = "tarot.txt";
    private String fileName = "tarot.txt";
    private String current;
    private Map<Integer, String> tarotMap = new HashMap<Integer, String>();
    private Set<Integer> reminderSet = new HashSet<Integer>();
    private NovaConfig config;

    public void getProperties(Map<String, Object> map) {
        map.put("tarot.reminder", this.reminderSet);
        map.put("tarot.current", this.current);
    }

    public void setProperties(Map<String, Object> map) {
        if (map.get("tarot.reminder") != null) {
            this.reminderSet = (Set)map.get("tarot.reminder");
        }
        this.current = (String)map.get("tarot.current");
    }

    public void reset() {
        this.current = null;
        this.reminderSet.clear();
        for (int i : this.tarotMap.keySet()) {
            this.reminderSet.add(i);
        }
        if (!this.config.isHirukoEnabled()) {
            this.reminderSet.remove(-1);
        }
        if (!this.config.isArashiEnabled()) {
            this.reminderSet.remove(-7);
        }
        if (!this.config.isKagemushaEnabled()) {
            this.reminderSet.remove(-9);
        }
        if (!this.config.isAyakashiEnabled()) {
            this.reminderSet.remove(-18);
        }
    }

    public void init() throws IOException {
        InputStream in = this.getClass().getResourceAsStream("/nova/tarot.txt");
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, "Windows-31J"));
        this.tarotMap.clear();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                if (line.length() <= 0) continue;
                String index = line.split(",")[0];
                this.tarotMap.put(Integer.parseInt(index), line);
            }
        }
        finally {
            reader.close();
        }
        this.reset();
    }

    public String next() throws IOException {
        if (this.reminderSet.size() == 0) {
            this.reset();
        }
        int nextIndex = (int)(Math.random() * (double)this.reminderSet.size());
        Iterator<Integer> iterator = this.reminderSet.iterator();
        int i = 0;
        while (i < nextIndex - 1) {
            iterator.next();
            ++i;
        }
        Integer key = iterator.next();
        this.current = this.tarotMap.get(key);
        this.reminderSet.remove(key);
        return this.current;
    }

    public void setFileName(String tarotFile) {
        this.fileName = tarotFile;
    }

    public String getFileName() {
        return this.fileName;
    }

    int count() {
        return this.tarotMap.size();
    }

    public String getSceneCard() {
        if (this.current == null) {
            return "";
        }
        return this.current;
    }

    public NovaConfig getConfig() {
        return this.config;
    }

    public void setConfig(NovaConfig config) {
        this.config = config;
    }
}

