/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.chaplet.nova.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.SystemColor;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.border.Border;
import jp.sf.chaplet.nova.Card;

public class CardListRenderer
extends DefaultListCellRenderer {
    private ImageIcon[] icons;
    private Border border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK, 3), BorderFactory.createEmptyBorder(15, 5, 15, 5)));
    private Border selectedBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(SystemColor.textHighlight, 3), BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK, 3), BorderFactory.createEmptyBorder(15, 5, 15, 5)));

    public CardListRenderer() {
        this.icons = new ImageIcon[4];
        this.icons[0] = new ImageIcon(this.getClass().getResource("/nova/spades.gif"));
        this.icons[1] = new ImageIcon(this.getClass().getResource("/nova/clubs.gif"));
        this.icons[2] = new ImageIcon(this.getClass().getResource("/nova/hearts.gif"));
        this.icons[3] = new ImageIcon(this.getClass().getResource("/nova/diams.gif"));
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        Card card = (Card)value;
        if (card != null) {
            if (isSelected) {
                this.setBorder(this.selectedBorder);
                this.setBackground(SystemColor.text);
            } else {
                this.setBorder(this.border);
            }
            if (card.isJoker()) {
                this.setIcon(null);
            } else {
                this.setIcon(this.icons[card.getSuite()]);
            }
            this.setText("<html><font color=\"#" + (card.isRed() ? "ff0000" : "000000") + "\">" + card.getRankString() + "</font></html>");
        }
        return comp;
    }
}

