/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.chaplet.nova.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.SystemColor;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import jp.sf.chaplet.nova.Plot;
import jp.sf.chaplet.nova.ui.PlotTableModel;

public class PlotTableCellRenderer
extends DefaultTableCellRenderer {
    private ImageIcon[] icons;
    private Border border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 8, 3, 8), BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK, 3), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
    private Border selectedBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(3, 8, 3, 8, SystemColor.textHighlight), BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK, 3), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
    private Border reactionBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 3, 8, 3), BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK, 3), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
    private Border reactionSelectedBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(8, 3, 8, 3, SystemColor.textHighlight), BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK, 3), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
    private PlotTableModel model;

    public PlotTableCellRenderer() {
        this.icons = new ImageIcon[4];
        this.icons[0] = new ImageIcon(this.getClass().getResource("/nova/spades.gif"));
        this.icons[1] = new ImageIcon(this.getClass().getResource("/nova/clubs.gif"));
        this.icons[2] = new ImageIcon(this.getClass().getResource("/nova/hearts.gif"));
        this.icons[3] = new ImageIcon(this.getClass().getResource("/nova/diams.gif"));
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setBackground(SystemColor.text);
        Plot plot = (Plot)value;
        if (plot != null) {
            if (plot.isReaction()) {
                if (isSelected) {
                    this.setBorder(this.reactionSelectedBorder);
                } else {
                    this.setBorder(this.reactionBorder);
                }
            } else if (isSelected) {
                this.setBorder(this.selectedBorder);
            } else {
                this.setBorder(this.border);
            }
            if (plot.getCard().isJoker()) {
                this.setIcon(null);
            } else {
                this.setIcon(this.icons[plot.getCard().getSuite()]);
            }
            this.setText("<html><font color=\"#" + (plot.getCard().isRed() ? "ff0000" : "000000") + "\">" + plot.getCard().getRankString() + "</font></html>");
        } else {
            this.setIcon(null);
            this.setBorder(null);
        }
        return comp;
    }

    public PlotTableModel getModel() {
        return this.model;
    }

    public void setModel(PlotTableModel model) {
        this.model = model;
    }
}

