/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.chaplet.nova.ui;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import jp.sf.chaplet.nova.Card;
import jp.sf.chaplet.nova.Plot;
import jp.sf.chaplet.nova.PlotChara;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlotTableModel
extends AbstractTableModel {
    public static final int COLUMN_CHARANO = 0;
    public static final int DEFAULT_COLUMN_COUNT = 5;
    private ArrayList<PlotChara> plotList = new ArrayList();
    private int columnCount = 5;
    private int longestRow = -1;

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return "No.";
        }
        return String.valueOf(String.valueOf(column)) + "\u679a\u76ee";
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public int getRowCount() {
        return this.plotList.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        PlotChara chara = this.plotList.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return chara.getCharaNo();
            }
        }
        if (chara.size() < columnIndex) {
            return null;
        }
        return chara.get(columnIndex - 1);
    }

    public void add(PlotChara chara) {
        this.plotList.add(chara);
        if (chara.size() >= this.columnCount) {
            this.longestRow = this.plotList.size() - 1;
            this.columnCount = chara.size() + 1;
            this.fireTableStructureChanged();
        } else {
            this.fireTableDataChanged();
        }
    }

    public void add(int charaNo, Card card) {
        PlotChara chara = this.getChara(charaNo);
        chara.add(new Plot(card, chara.getCharaNo(), false));
        if (chara.size() >= this.columnCount) {
            this.longestRow = this.plotList.indexOf(chara);
            this.columnCount = chara.size() + 1;
            this.fireTableStructureChanged();
        } else {
            this.fireTableDataChanged();
        }
    }

    public void remove(int charaNo) {
        this.plotList.remove(charaNo - 1);
        if (this.longestRow == charaNo - 1) {
            int max = 0;
            int index = 0;
            int i = 0;
            while (i < this.plotList.size()) {
                PlotChara chara = this.plotList.get(i);
                if (max < chara.size()) {
                    max = chara.size();
                    index = i;
                }
                ++i;
            }
            if (max >= this.columnCount) {
                this.columnCount = max + 1;
                this.longestRow = index;
            }
            this.fireTableStructureChanged();
        } else {
            this.fireTableDataChanged();
        }
    }

    public void remove(int charaNo, Card card) {
        PlotChara chara = this.getChara(charaNo);
        chara.remove(card);
        if (this.longestRow == this.plotList.indexOf(chara)) {
            int max = 0;
            int index = 0;
            int i = 0;
            while (i < this.plotList.size()) {
                chara = this.plotList.get(i);
                if (max < chara.size()) {
                    max = chara.size();
                    index = i;
                }
                ++i;
            }
            if (max >= 5) {
                this.columnCount = max + 1;
                this.longestRow = index;
            } else {
                this.columnCount = 5;
                this.longestRow = -1;
            }
            this.fireTableStructureChanged();
        } else {
            this.fireTableDataChanged();
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return String.class;
        }
        return PlotChara.class;
    }

    public Plot getPlot(int charaNo, int index) {
        for (PlotChara chara : this.plotList) {
            if (chara.getCharaNo() != charaNo) continue;
            if (chara.size() > index) {
                return chara.get(index);
            }
            return null;
        }
        return null;
    }

    public PlotChara getChara(int charaNo) {
        for (PlotChara chara : this.plotList) {
            if (chara.getCharaNo() != charaNo) continue;
            return chara;
        }
        return null;
    }

    public PlotChara indexOf(int index) {
        if (this.plotList.size() <= index) {
            return null;
        }
        return this.plotList.get(index);
    }

    public int getRowIndex(int charaNo) {
        int i = 0;
        while (i < this.plotList.size()) {
            PlotChara chara = this.plotList.get(i);
            if (chara.getCharaNo() == charaNo) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

