/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.clipboardSupport;

import charactermanaj.clipboardSupport.ImageSelection;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.IOException;

public final class ClipboardUtil {
    private ClipboardUtil() {
    }

    public static void setImage(BufferedImage img, Color bgColor) {
        if (img == null || bgColor == null) {
            throw new IllegalArgumentException();
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        Clipboard cb = tk.getSystemClipboard();
        ImageSelection imageSelection = new ImageSelection(img, bgColor);
        cb.setContents(imageSelection, null);
    }

    public static boolean hasImage() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Clipboard cb = tk.getSystemClipboard();
        return cb.isDataFlavorAvailable(DataFlavor.imageFlavor) || cb.isDataFlavorAvailable(ImageSelection.bufferedImageDataFlavor);
    }

    public static BufferedImage getImage() throws IOException {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Clipboard cb = tk.getSystemClipboard();
        try {
            if (cb.isDataFlavorAvailable(ImageSelection.bufferedImageDataFlavor)) {
                return (BufferedImage)cb.getData(ImageSelection.bufferedImageDataFlavor);
            }
            if (cb.isDataFlavorAvailable(DataFlavor.imageFlavor)) {
                return (BufferedImage)cb.getData(DataFlavor.imageFlavor);
            }
        }
        catch (UnsupportedFlavorException ex) {
            throw new IOException(ex.getMessage());
        }
        return null;
    }
}

