/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.graphics.io;

import charactermanaj.graphics.io.ImageCache;
import charactermanaj.graphics.io.ImageLoader;
import charactermanaj.graphics.io.ImageResource;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.imageio.ImageIO;

public class ImageCachedLoader
implements ImageLoader {
    private int cacheSize;
    private long sweepThreshold;
    private LinkedList<ImageCache> caches = new LinkedList();

    public ImageCachedLoader(int cacheSize, long sweepThreshold) {
        this.cacheSize = cacheSize;
        this.sweepThreshold = sweepThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage load(ImageResource imageResource) throws IOException {
        if (imageResource == null) {
            throw new IllegalArgumentException();
        }
        long now = System.currentTimeMillis();
        long lastModified = imageResource.lastModified();
        BufferedImage image = null;
        LinkedList<ImageCache> linkedList = this.caches;
        synchronized (linkedList) {
            Iterator ite = this.caches.iterator();
            while (ite.hasNext()) {
                ImageCache cache = (ImageCache)ite.next();
                if (!((Object)imageResource).equals(cache.getImageResource()) || cache.getLastModified() != lastModified) continue;
                cache.setLastUsed(now);
                ite.remove();
                this.caches.addFirst(cache);
                image = cache.getImage();
                break;
            }
        }
        if (image == null) {
            image = ImageIO.read(imageResource.openStream());
            if (image == null) {
                throw new IOException("unsupported image");
            }
            int typ = image.getType();
            if (typ != 2) {
                BufferedImage img2 = new BufferedImage(image.getWidth(), image.getHeight(), 2);
                Graphics g = img2.getGraphics();
                try {
                    g.drawImage(image, 0, 0, null);
                }
                finally {
                    g.dispose();
                }
                image = img2;
            }
            ImageCache cache = new ImageCache();
            cache.setImageResource(imageResource);
            cache.setLastModified(lastModified);
            cache.setLastUsed(now);
            cache.setImage(image);
            LinkedList<ImageCache> linkedList2 = this.caches;
            synchronized (linkedList2) {
                this.caches.addFirst(cache);
            }
        }
        this.sweep();
        return image;
    }

    public void sweep() {
        this.sweep(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sweep(File file) {
        long now = System.currentTimeMillis();
        LinkedList<ImageCache> linkedList = this.caches;
        synchronized (linkedList) {
            Iterator ite = this.caches.iterator();
            while (ite.hasNext()) {
                ImageCache cache = (ImageCache)ite.next();
                if (now - cache.getLastUsed() > this.sweepThreshold) {
                    ite.remove();
                    continue;
                }
                if (file == null || !file.equals(cache.getImageResource())) continue;
                ite.remove();
                file = null;
            }
            while (this.caches.size() > this.cacheSize) {
                this.caches.removeLast();
            }
        }
    }
}

