/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model;

import charactermanaj.model.AppConfig;
import charactermanaj.model.ColorGroup;
import charactermanaj.model.Layer;
import charactermanaj.model.OrderedMap;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsColorManager;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsSet;
import charactermanaj.model.PartsSpec;
import charactermanaj.model.PartsSpecResolver;
import charactermanaj.model.io.PartsDataLoader;
import charactermanaj.util.ApplicationLogger;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharacterData
implements Serializable,
PartsSpecResolver {
    private static final long serialVersionUID = -381763373314240953L;
    private static final Logger logger = ApplicationLogger.getLogger();
    public static final Comparator<CharacterData> SORT_DISPLAYNAME = new Comparator<CharacterData>(){

        @Override
        public int compare(CharacterData o1, CharacterData o2) {
            if (!o1.isValid() || !o2.isValid()) {
                return o1.isValid() == o2.isValid() ? 0 : (o1.isValid() ? 1 : -1);
            }
            int ret = o1.getName().compareTo(o2.getName());
            if (ret == 0) {
                ret = o1.getId().compareTo(o2.getId());
            }
            if (ret == 0) {
                ret = o1.getDocBase().toString().compareTo(o2.getDocBase().toString());
            }
            return ret;
        }
    };
    private URL docBase;
    private String id;
    private String rev;
    private String localizedName;
    private String author;
    private String description;
    private Dimension imageSize;
    private OrderedMap<String, PartsCategory> partsCategories = OrderedMap.emptyMap();
    private Properties properties = new Properties();
    private HashMap<String, PartsSet> presets = new HashMap();
    private String defaultPartsSetId;
    private OrderedMap<String, ColorGroup> colorGroups = OrderedMap.emptyMap();
    private transient PartsColorManager partsColorMrg = new PartsColorManager(this);
    private transient PartsDataLoader partsDataLoader;
    private Map<PartsCategory, Map<PartsIdentifier, PartsSpec>> images = new HashMap<PartsCategory, Map<PartsIdentifier, PartsSpec>>();

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    public CharacterData duplicateBasicInfo(boolean generateNewId) {
        CharacterData cd = new CharacterData();
        if (!generateNewId) {
            cd.setId(this.id);
            cd.setRev(this.rev);
            cd.setDocBase(this.docBase);
        } else {
            String uuid = UUID.randomUUID().toString();
            cd.setId("cd" + uuid);
            cd.setRev("rev" + uuid);
            cd.setDocBase(null);
        }
        cd.setName(this.localizedName);
        cd.setAuthor(this.author);
        cd.setDescription(this.description);
        cd.setImageSize(this.getImageSize());
        ArrayList<PartsCategory> partsCategories = new ArrayList<PartsCategory>();
        partsCategories.addAll(this.getPartsCategories());
        cd.setPartsCategories(partsCategories.toArray(new PartsCategory[partsCategories.size()]));
        ArrayList<ColorGroup> colorGroups = new ArrayList<ColorGroup>();
        colorGroups.addAll(this.getColorGroups());
        cd.setColorGroups(colorGroups);
        for (PartsSet partsSet : this.getPartsSets().values()) {
            cd.addPartsSet(partsSet.clone());
        }
        cd.setDefaultPartsSetId(this.defaultPartsSetId);
        return cd;
    }

    public boolean isSameStructure(CharacterData other) {
        if (other == null) {
            throw new IllegalArgumentException();
        }
        if (!this.isValid() || !other.isValid()) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.imageSize == null ? other.images != null : other.images == null || !this.imageSize.equals(other.imageSize)) {
            return false;
        }
        ArrayList<ColorGroup> colorGroup1 = new ArrayList<ColorGroup>(this.getColorGroups());
        ArrayList<ColorGroup> colorGroup2 = new ArrayList<ColorGroup>(other.getColorGroups());
        if (colorGroup1.size() != colorGroup2.size()) {
            return false;
        }
        if (!colorGroup1.containsAll(colorGroup2)) {
            return false;
        }
        ArrayList<PartsCategory> categories1 = new ArrayList<PartsCategory>(this.getPartsCategories());
        ArrayList<PartsCategory> categories2 = new ArrayList<PartsCategory>(other.getPartsCategories());
        Comparator<PartsCategory> sortCategoryId = new Comparator<PartsCategory>(){

            @Override
            public int compare(PartsCategory o1, PartsCategory o2) {
                int ret = o1.getCategoryId().compareTo(o2.getCategoryId());
                if (ret == 0) {
                    ret = o1.getOrder() - o2.getOrder();
                }
                return ret;
            }
        };
        Collections.sort(categories1, sortCategoryId);
        Collections.sort(categories2, sortCategoryId);
        if (!categories1.equals(categories2)) {
            return false;
        }
        int mx = categories1.size();
        for (int idx = 0; idx < mx; ++idx) {
            PartsCategory category1 = categories1.get(idx);
            PartsCategory category2 = categories2.get(idx);
            ArrayList<Layer> layers1 = new ArrayList<Layer>(category1.getLayers());
            ArrayList<Layer> layers2 = new ArrayList<Layer>(category2.getLayers());
            Comparator<Layer> sortLayerId = new Comparator<Layer>(){

                @Override
                public int compare(Layer o1, Layer o2) {
                    int ret = o1.getId().compareTo(o2.getId());
                    if (ret == 0) {
                        ret = o1.getOrder() - o2.getOrder();
                    }
                    return ret;
                }
            };
            Collections.sort(layers1, sortLayerId);
            Collections.sort(layers2, sortLayerId);
            if (layers1.equals(layers2)) continue;
            return false;
        }
        return true;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.partsColorMrg = new PartsColorManager(this);
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setDescription(String description) {
        if (description != null) {
            description = description.replace("\r\n", "\n");
            description = description.replace("\r", "\n");
            description = description.replace("\n", System.getProperty("line.separator"));
        }
        this.description = description;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRev() {
        return this.rev;
    }

    public void setRev(String rev) {
        this.rev = rev;
    }

    public void setDocBase(URL docBase) {
        this.docBase = docBase;
    }

    public URL getDocBase() {
        return this.docBase;
    }

    public boolean isWatchDirectory() {
        try {
            String value = this.properties.getProperty("watch-dir");
            if (value != null) {
                return Boolean.parseBoolean(value);
            }
        }
        catch (RuntimeException ex) {
            logger.log(Level.WARNING, "watch-dir property is invalid.", ex);
        }
        return true;
    }

    public void setWatchDirectory(boolean watchDir) {
        this.properties.setProperty("watch-dir", Boolean.toString(watchDir));
    }

    public String getProperty(String key) {
        if (key == null || key.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        return this.properties.getProperty(key.trim());
    }

    public void setProperty(String key, String value) {
        if (key == null || key.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        this.properties.setProperty(key.trim(), value);
    }

    public Collection<String> getPropertyNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (Object key : this.properties.keySet()) {
            names.add(key.toString());
        }
        return names;
    }

    public boolean isValid() {
        return this.id != null && this.id.length() > 0 && this.localizedName != null && this.localizedName.length() > 0 && this.docBase != null;
    }

    public boolean canWrite() {
        File parent;
        File xmlFile;
        if (this.docBase == null) {
            return true;
        }
        return this.docBase.getProtocol().equals("file") && (!(xmlFile = new File(this.docBase.getPath())).exists() ? (parent = xmlFile.getParentFile()).exists() && parent.canWrite() && parent.canRead() : xmlFile.canWrite() && xmlFile.canRead());
    }

    public boolean isDefaultProfile() {
        if (!this.isValid()) {
            return false;
        }
        AppConfig appConfig = AppConfig.getInstance();
        String defaultProfileId = appConfig.getDefaultProfileId();
        return defaultProfileId != null && defaultProfileId.equals(this.id);
    }

    public void setName(String name) {
        this.localizedName = name;
    }

    public String getName() {
        return this.localizedName;
    }

    public void setImageSize(Dimension imageSize) {
        if (imageSize != null) {
            imageSize = (Dimension)imageSize.clone();
        }
        this.imageSize = imageSize;
    }

    @Override
    public Dimension getImageSize() {
        return this.imageSize != null ? (Dimension)this.imageSize.clone() : null;
    }

    public void setColorGroups(Collection<ColorGroup> colorGroups) {
        if (colorGroups == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<ColorGroup> colorGroupWithNA = new ArrayList<ColorGroup>();
        colorGroupWithNA.add(ColorGroup.NA);
        for (ColorGroup colorGroup : colorGroups) {
            if (!colorGroup.isEnabled()) continue;
            colorGroupWithNA.add(colorGroup);
        }
        OrderedMap<String, ColorGroup> ret = new OrderedMap<String, ColorGroup>(colorGroupWithNA, new OrderedMap.KeyDetector<String, ColorGroup>(){

            @Override
            public String getKey(ColorGroup data) {
                return data.getId();
            }
        });
        this.colorGroups = ret;
    }

    public ColorGroup getColorGroup(String colorGroupId) {
        ColorGroup cg = this.colorGroups.get(colorGroupId);
        if (cg != null) {
            return cg;
        }
        return ColorGroup.NA;
    }

    public Collection<ColorGroup> getColorGroups() {
        return this.colorGroups.values();
    }

    @Override
    public PartsCategory getPartsCategory(String categoryId) {
        if (this.partsCategories == null) {
            return null;
        }
        return this.partsCategories.get(categoryId);
    }

    public void setPartsCategories(PartsCategory[] partsCategories) {
        if (partsCategories == null) {
            partsCategories = new PartsCategory[]{};
        }
        this.partsCategories = new OrderedMap<String, PartsCategory>(Arrays.asList(partsCategories), new OrderedMap.KeyDetector<String, PartsCategory>(){

            @Override
            public String getKey(PartsCategory data) {
                return data.getCategoryId();
            }
        });
    }

    @Override
    public List<PartsCategory> getPartsCategories() {
        return this.partsCategories.asList();
    }

    public void loadPartsData(PartsDataLoader partsDataLoader) {
        if (partsDataLoader == null) {
            throw new IllegalArgumentException();
        }
        this.partsDataLoader = partsDataLoader;
        this.reloadPartsData();
    }

    public boolean reloadPartsData() {
        if (this.partsDataLoader == null) {
            throw new IllegalStateException("partsDataLoader is not set.");
        }
        this.images.clear();
        for (PartsCategory category : this.partsCategories.asList()) {
            this.images.put(category, this.partsDataLoader.load(category));
        }
        return true;
    }

    @Override
    public PartsSpec getPartsSpec(PartsIdentifier partsIdentifier) {
        PartsSpec partsSpec;
        if (partsIdentifier == null) {
            throw new IllegalArgumentException();
        }
        PartsCategory partsCategory = partsIdentifier.getPartsCategory();
        Map<PartsIdentifier, PartsSpec> partsSpecMap = this.images.get(partsCategory);
        if (partsSpecMap != null && (partsSpec = partsSpecMap.get(partsIdentifier)) != null) {
            return partsSpec;
        }
        return null;
    }

    @Override
    public Map<PartsIdentifier, PartsSpec> getPartsSpecMap(PartsCategory category) {
        Map<PartsIdentifier, PartsSpec> partsImageMap = this.images.get(category);
        if (partsImageMap == null) {
            return Collections.emptyMap();
        }
        return partsImageMap;
    }

    public PartsColorManager getPartsColorManager() {
        return this.partsColorMrg;
    }

    public boolean addPartsSet(PartsSet partsSet) {
        if (partsSet == null) {
            throw new IllegalArgumentException();
        }
        if (partsSet.getPartsSetId() == null || partsSet.getPartsSetId().length() == 0 || partsSet.getLocalizedName() == null || partsSet.getLocalizedName().length() == 0) {
            return false;
        }
        PartsSet compatiblePartsSet = partsSet.createCompatible(this);
        if (compatiblePartsSet.isEmpty()) {
            return false;
        }
        this.presets.put(compatiblePartsSet.getPartsSetId(), compatiblePartsSet);
        return true;
    }

    public Map<String, PartsSet> getPartsSets() {
        return this.presets;
    }

    public void clearPartsSets(boolean noRemovePreset) {
        if (!noRemovePreset) {
            this.presets.clear();
            this.defaultPartsSetId = null;
        } else {
            Iterator<Map.Entry<String, PartsSet>> ite = this.presets.entrySet().iterator();
            while (ite.hasNext()) {
                Map.Entry<String, PartsSet> entry = ite.next();
                if (entry.getValue().isPresetParts()) continue;
                if (entry.getKey().equals(this.defaultPartsSetId)) {
                    this.defaultPartsSetId = null;
                }
                ite.remove();
            }
        }
    }

    public String getDefaultPartsSetId() {
        return this.defaultPartsSetId;
    }

    public void setDefaultPartsSetId(String defaultPartsSetId) {
        this.defaultPartsSetId = defaultPartsSetId;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("character-id: " + this.id);
        buf.append("/rev:" + this.rev);
        buf.append("/name:" + this.localizedName);
        buf.append("/image-size:" + this.imageSize.width + "x" + this.imageSize.height);
        buf.append("/docBase:" + this.docBase);
        return buf.toString();
    }
}

