/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.model;

import charactermanaj.model.PartsAuthorInfo;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.model.PartsManageData;
import charactermanaj.model.PartsSpec;

public class PartsManageDataConverter {
    private PartsManageData partsManageData;

    public PartsManageDataConverter() {
        this(null);
    }

    public PartsManageDataConverter(PartsManageData partsManageData) {
        this.partsManageData = partsManageData == null ? new PartsManageData() : partsManageData;
    }

    public PartsManageData getPartsManageData() {
        return this.partsManageData;
    }

    public void convert(PartsIdentifier partsIdentifier, PartsSpec partsSpec) {
        String downloadURL;
        double version;
        if (partsIdentifier == null) {
            throw new IllegalArgumentException();
        }
        String localizedName = partsIdentifier.getLocalizedPartsName();
        if (partsSpec != null) {
            version = partsSpec.getVersion();
            downloadURL = partsSpec.getDownloadURL();
        } else {
            version = 0.0;
            downloadURL = null;
        }
        PartsAuthorInfo partsAuthorInfo = partsSpec.getAuthorInfo();
        PartsManageData.PartsVersionInfo versionInfo = new PartsManageData.PartsVersionInfo();
        versionInfo.setDownloadURL(downloadURL);
        versionInfo.setVersion(version);
        PartsManageData.PartsKey partsKey = new PartsManageData.PartsKey(partsIdentifier);
        this.partsManageData.putPartsInfo(partsKey, localizedName, partsAuthorInfo, versionInfo);
    }
}

