/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.graphics.filters.ColorConvertParameter;
import charactermanaj.model.AppConfig;
import charactermanaj.model.ColorGroup;
import charactermanaj.model.Layer;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsIdentifier;
import charactermanaj.ui.ColorDialogTabPanel;
import charactermanaj.ui.model.ColorChangeEvent;
import charactermanaj.ui.model.ColorChangeListener;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final PartsCategory partsCategory;
    private HashMap<Layer, ColorDialogTabPanel> tabs = new HashMap();
    private LinkedList<ColorChangeListener> listeners = new LinkedList();
    private String captionBase;
    private PartsIdentifier partsIdentifier;
    private JCheckBox chkApplyAll;

    public ColorDialog(JFrame parent, PartsCategory partsCategory, Collection<ColorGroup> colorGroups) {
        super(parent);
        this.partsCategory = partsCategory;
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties("strings/colordialog");
        String caption = strings.getProperty("colordialog.caption");
        String name = partsCategory.getLocalizedCategoryName();
        this.captionBase = caption + name;
        this.setTitle(this.captionBase);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ColorDialog.this.setVisible(false);
            }
        });
        Container container = this.getContentPane();
        JTabbedPane tabbedPane = new JTabbedPane(1, 0);
        for (final Layer layer : partsCategory.getLayers()) {
            ColorDialogTabPanel tabContainer = new ColorDialogTabPanel(this, layer, colorGroups);
            ColorChangeListener innerListener = new ColorChangeListener(){
                private Semaphore semaphore = new Semaphore(1);

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onColorChange(ColorChangeEvent event) {
                    if (this.semaphore.tryAcquire()) {
                        try {
                            ColorDialog.this.fireColorChangeEvent(layer, false);
                        }
                        finally {
                            this.semaphore.release();
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onColorGroupChange(ColorChangeEvent event) {
                    if (this.semaphore.tryAcquire()) {
                        try {
                            ColorDialog.this.fireColorGroupChangeEvent(layer);
                            ColorDialog.this.fireColorChangeEvent(layer, false);
                        }
                        finally {
                            this.semaphore.release();
                        }
                    }
                }
            };
            tabContainer.addColorChangeListener(innerListener);
            tabbedPane.addTab(layer.getLocalizedName(), tabContainer);
            this.tabs.put(layer, tabContainer);
        }
        JPanel btnPanel = new JPanel(new BorderLayout());
        btnPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JButton btnApply = new JButton(strings.getProperty("button.apply"));
        btnApply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                for (Layer layer : ColorDialog.this.getPartsCategory().getLayers()) {
                    ColorDialog.this.fireColorChangeEvent(layer, true);
                }
            }
        });
        btnPanel.add((Component)btnApply, "East");
        this.chkApplyAll = new JCheckBox(strings.getProperty("checkbox.applyAllItems"));
        this.chkApplyAll.setSelected(!partsCategory.isMultipleSelectable());
        btnPanel.add((Component)this.chkApplyAll, "West");
        container.setLayout(new BorderLayout());
        container.add((Component)tabbedPane, "Center");
        container.add((Component)btnPanel, "South");
        this.getRootPane().setDefaultButton(btnApply);
        this.pack();
    }

    public void adjustLocation(int offset_y) {
        Point pt = this.getParent().getLocation();
        Insets insets = this.getParent().getInsets();
        pt.x += this.getParent().getWidth();
        pt.y += offset_y * insets.top;
        this.setLocation(pt);
    }

    public PartsCategory getPartsCategory() {
        return this.partsCategory;
    }

    public boolean isSyncColorGroup(Layer layer) {
        ColorDialogTabPanel tab = this.tabs.get(layer);
        if (tab == null) {
            return false;
        }
        return tab.isSyncColorGroup();
    }

    public void setSyncColorGroup(Layer layer, boolean selected) {
        ColorDialogTabPanel tab = this.tabs.get(layer);
        if (tab != null) {
            tab.setSyncColorGroup(selected);
        }
    }

    public void setColorConvertParameters(Map<Layer, ColorConvertParameter> params) {
        if (params == null) {
            throw new IllegalArgumentException();
        }
        for (Layer layer : this.partsCategory.getLayers()) {
            ColorConvertParameter param = params.get(layer);
            if (param == null) {
                param = new ColorConvertParameter();
            }
            this.setColorConvertParameter(layer, param);
        }
    }

    public void setPartsIdentifier(PartsIdentifier partsIdentifier) {
        this.partsIdentifier = partsIdentifier;
        if (partsIdentifier == null) {
            this.setTitle(this.captionBase);
        } else {
            this.setTitle(this.captionBase + "(" + partsIdentifier.getLocalizedPartsName() + ")");
        }
    }

    public PartsIdentifier getPartsIdentifier() {
        return this.partsIdentifier;
    }

    public boolean isApplyAll() {
        return this.chkApplyAll.isSelected();
    }

    public Map<Layer, ColorConvertParameter> getColorConvertParameters() {
        HashMap<Layer, ColorConvertParameter> params = new HashMap<Layer, ColorConvertParameter>();
        for (Layer layer : this.partsCategory.getLayers()) {
            ColorDialogTabPanel tab = this.tabs.get(layer);
            ColorConvertParameter param = tab.getColorConvertParameter();
            params.put(layer, param);
        }
        return params;
    }

    public void setColorConvertParameter(Layer layer, ColorConvertParameter param) {
        if (layer == null || param == null) {
            throw new IllegalArgumentException();
        }
        ColorDialogTabPanel tab = this.tabs.get(layer);
        if (tab == null) {
            throw new IllegalArgumentException("layer not found. " + layer + "/tabs=" + this.tabs);
        }
        tab.setColorConvertParameter(param);
    }

    public ColorConvertParameter getColorConvertParameter(Layer layer) {
        if (layer == null) {
            throw new IllegalArgumentException();
        }
        ColorDialogTabPanel tab = this.tabs.get(layer);
        if (tab == null) {
            throw new IllegalArgumentException("layer not found. " + layer);
        }
        return tab.getColorConvertParameter();
    }

    public ColorGroup getColorGroup(Layer layer) {
        if (layer == null) {
            throw new IllegalArgumentException();
        }
        ColorDialogTabPanel tab = this.tabs.get(layer);
        if (tab == null) {
            throw new IllegalArgumentException("layer not found. " + layer);
        }
        return tab.getColorGroup();
    }

    public void setColorGroup(Layer layer, ColorGroup colorGroup) {
        if (layer == null || colorGroup == null) {
            throw new IllegalArgumentException();
        }
        ColorDialogTabPanel tab = this.tabs.get(layer);
        if (tab != null) {
            tab.setColorGroup(colorGroup);
        }
    }

    public void addColorChangeListener(ColorChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.listeners.add(listener);
    }

    public void removeColorChangeListener(ColorChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireColorChangeEvent(Layer layer, boolean force) {
        AppConfig appConfig;
        if (layer == null) {
            throw new IllegalArgumentException();
        }
        if (!force && !(appConfig = AppConfig.getInstance()).isEnableAutoColorChange()) {
            return;
        }
        ColorChangeEvent event = new ColorChangeEvent(this, layer);
        for (ColorChangeListener listener : this.listeners) {
            listener.onColorChange(event);
        }
    }

    protected void fireColorGroupChangeEvent(Layer layer) {
        if (layer == null) {
            throw new IllegalArgumentException();
        }
        ColorChangeEvent event = new ColorChangeEvent(this, layer);
        for (ColorChangeListener listener : this.listeners) {
            listener.onColorGroupChange(event);
        }
    }

    @Override
    public String toString() {
        return "ColorDialog(partsCategory:" + this.partsCategory + ")";
    }
}

