/*
 * Decompiled with CFR 0.152.
 */
package charactermanaj.ui;

import charactermanaj.Main;
import charactermanaj.model.AppConfig;
import charactermanaj.model.CharacterData;
import charactermanaj.model.PartsAuthorInfo;
import charactermanaj.model.PartsCategory;
import charactermanaj.model.PartsManageData;
import charactermanaj.model.PartsSet;
import charactermanaj.model.io.AbstractCharacterDataArchiveFile;
import charactermanaj.model.io.CharacterDataPersistent;
import charactermanaj.ui.ImportFileSelectPanel;
import charactermanaj.ui.ImportPartsSelectPanel;
import charactermanaj.ui.ImportPresetSelectPanel;
import charactermanaj.ui.ImportTypeSelectPanel;
import charactermanaj.ui.ImportWizardCardPanel;
import charactermanaj.util.ErrorMessageHelper;
import charactermanaj.util.LocalizedResourcePropertyLoader;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportWizardDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected static final String STRINGS_RESOURCE = "strings/importwizdialog";
    public static final int EXIT_PROFILE_UPDATED = 1;
    public static final int EXIT_PROFILE_CREATED = 2;
    public static final int EXIT_CANCELED = 0;
    private int exitCode = 0;
    private CharacterData importedCharacterData;
    protected CharacterData current;
    protected Collection<CharacterData> profiles;
    private CardLayout mainPanelLayout;
    private ImportWizardCardPanel activePanel;
    private AbstractAction actNext;
    private AbstractAction actPrev;
    private AbstractAction actFinish;
    protected ImportFileSelectPanel fileSelectPanel;
    protected ImportTypeSelectPanel importTypeSelectPanel;
    protected ImportPartsSelectPanel importPartsSelectPanel;
    protected ImportPresetSelectPanel importPresetSelectPanel;

    public ImportWizardDialog(JFrame parent, CharacterData current) {
        super((Frame)parent, true);
        if (current == null) {
            throw new IllegalArgumentException();
        }
        this.initComponent(parent, current, null);
    }

    public ImportWizardDialog(JDialog parent, CharacterData current, Collection<CharacterData> profiles) {
        super((Dialog)parent, true);
        if (profiles == null) {
            throw new IllegalArgumentException();
        }
        this.initComponent(parent, current, profiles);
    }

    private void initComponent(Component parent, CharacterData current, Collection<CharacterData> profiles) {
        this.current = current;
        this.profiles = profiles;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ImportWizardDialog.this.onClose();
            }
        });
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
        this.setTitle(strings.getProperty("title"));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        final JPanel mainPanel = new JPanel();
        mainPanel.setBorder(BorderFactory.createEtchedBorder());
        this.mainPanelLayout = new CardLayout(5, 5);
        mainPanel.setLayout(this.mainPanelLayout);
        contentPane.add((Component)mainPanel, "Center");
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ImportWizardDialog.this.updateBtnPanelState();
            }
        };
        ComponentAdapter componentListener = new ComponentAdapter(){

            public void componentShown(ComponentEvent e) {
                ImportWizardDialog.this.onComponentShown((ImportWizardCardPanel)e.getComponent());
            }
        };
        this.actNext = new AbstractAction(strings.getProperty("btn.next")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ImportWizardDialog.this.setEnableButtons(false);
                String nextPanelName = ImportWizardDialog.this.doNext();
                if (nextPanelName != null) {
                    ImportWizardDialog.this.mainPanelLayout.show(mainPanel, nextPanelName);
                } else {
                    ImportWizardDialog.this.updateBtnPanelState();
                }
            }
        };
        this.actPrev = new AbstractAction(strings.getProperty("btn.prev")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ImportWizardDialog.this.setEnableButtons(false);
                String prevPanelName = ImportWizardDialog.this.doPrevious();
                if (prevPanelName != null) {
                    ImportWizardDialog.this.mainPanelLayout.show(mainPanel, prevPanelName);
                } else {
                    ImportWizardDialog.this.updateBtnPanelState();
                }
            }
        };
        this.actFinish = new AbstractAction(strings.getProperty("btn.finish")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ImportWizardDialog.this.onFinish();
            }
        };
        AbstractAction actCancel = new AbstractAction(strings.getProperty("btn.cancel")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ImportWizardDialog.this.onClose();
            }
        };
        this.fileSelectPanel = new ImportFileSelectPanel();
        this.fileSelectPanel.addComponentListener(componentListener);
        this.fileSelectPanel.addChangeListener(changeListener);
        mainPanel.add((Component)this.fileSelectPanel, "fileSelectPanel");
        this.importTypeSelectPanel = new ImportTypeSelectPanel();
        this.importTypeSelectPanel.addComponentListener(componentListener);
        this.importTypeSelectPanel.addChangeListener(changeListener);
        mainPanel.add((Component)this.importTypeSelectPanel, "importTypeSelectPanel");
        this.importPartsSelectPanel = new ImportPartsSelectPanel();
        this.importPartsSelectPanel.addComponentListener(componentListener);
        this.importPartsSelectPanel.addChangeListener(changeListener);
        mainPanel.add((Component)this.importPartsSelectPanel, "importPartsSelectPanel");
        this.importPresetSelectPanel = new ImportPresetSelectPanel();
        this.importPresetSelectPanel.addComponentListener(componentListener);
        this.importPresetSelectPanel.addChangeListener(changeListener);
        mainPanel.add((Component)this.importPresetSelectPanel, "importPresetSelectPanel");
        JPanel btnPanel = new JPanel();
        btnPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 45));
        GridBagLayout btnPanelLayout = new GridBagLayout();
        btnPanel.setLayout(btnPanelLayout);
        this.actPrev.setEnabled(false);
        this.actNext.setEnabled(false);
        this.actFinish.setEnabled(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 13;
        gbc.fill = 1;
        gbc.ipadx = 0;
        gbc.ipady = 0;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        btnPanel.add(Box.createHorizontalGlue(), gbc);
        gbc.gridx = Main.isMacOSX() ? 2 : 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        btnPanel.add((Component)new JButton(this.actPrev), gbc);
        gbc.gridx = Main.isMacOSX() ? 3 : 2;
        gbc.gridy = 0;
        JButton btnNext = new JButton(this.actNext);
        btnPanel.add((Component)btnNext, gbc);
        gbc.gridx = Main.isMacOSX() ? 4 : 3;
        gbc.gridy = 0;
        btnPanel.add((Component)new JButton(this.actFinish), gbc);
        gbc.gridx = Main.isMacOSX() ? 1 : 4;
        gbc.gridy = 0;
        JButton btnCancel = new JButton(actCancel);
        btnPanel.add((Component)btnCancel, gbc);
        contentPane.add((Component)btnPanel, "South");
        JRootPane rootPane = this.getRootPane();
        rootPane.setDefaultButton(btnNext);
        InputMap im = rootPane.getInputMap(2);
        ActionMap am = rootPane.getActionMap();
        im.put(KeyStroke.getKeyStroke(27, 0), "closeImportWizDialog");
        am.put("closeImportWizDialog", actCancel);
        this.setSize(500, 500);
        this.setLocationRelativeTo(parent);
        this.mainPanelLayout.first(mainPanel);
        this.updateBtnPanelState();
    }

    protected void onComponentShown(JPanel panel) {
        ImportWizardCardPanel activePanel = (ImportWizardCardPanel)panel;
        activePanel.onActive(this, this.activePanel);
        this.activePanel = activePanel;
        this.updateBtnPanelState();
    }

    protected void updateBtnPanelState() {
        if (this.activePanel != null) {
            this.actPrev.setEnabled(this.activePanel.isReadyPrevious());
            this.actNext.setEnabled(this.activePanel.isReadyNext());
            this.actFinish.setEnabled(this.activePanel.isReadyFinish());
        } else {
            this.setEnableButtons(false);
        }
    }

    public void setEnableButtons(boolean enabled) {
        this.actPrev.setEnabled(enabled);
        this.actNext.setEnabled(enabled);
        this.actFinish.setEnabled(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doNext() {
        String nextPanelName;
        if (this.activePanel == null) {
            throw new IllegalStateException();
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            nextPanelName = this.activePanel.doNext();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
        return nextPanelName;
    }

    protected String doPrevious() {
        if (this.activePanel == null) {
            throw new IllegalStateException();
        }
        return this.activePanel.doPrevious();
    }

    protected void onClose() {
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
        if (JOptionPane.showConfirmDialog(this, strings.getProperty("confirm.close"), strings.getProperty("confirm"), 0, 3) != 0) {
            return;
        }
        this.fileSelectPanel.closeArchive();
        this.exitCode = 0;
        this.importedCharacterData = null;
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onFinish() {
        Properties strings = LocalizedResourcePropertyLoader.getInstance().getLocalizedProperties(STRINGS_RESOURCE);
        try {
            int exitCode;
            CharacterData importedCharacterData;
            if (this.importTypeSelectPanel.isNewProfile()) {
                int ret;
                CharacterData newCd = this.fileSelectPanel.getCharacterData();
                if (newCd == null || !newCd.isValid() || this.profiles == null) {
                    return;
                }
                String profileId = newCd.getId();
                boolean existsSameId = false;
                for (CharacterData cd : this.profiles) {
                    if (cd == null || !cd.isValid() || !cd.getId().equals(profileId)) continue;
                    existsSameId = true;
                    break;
                }
                if (existsSameId && (ret = JOptionPane.showConfirmDialog(this, strings.getProperty("existsSameProfileId"), strings.getProperty("confirm"), 0, 3)) != 0) {
                    return;
                }
            }
            this.setEnableButtons(false);
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                if (this.importTypeSelectPanel.isNewProfile()) {
                    importedCharacterData = this.createNewProfile();
                    exitCode = 2;
                } else {
                    importedCharacterData = this.updateProfile();
                    exitCode = 1;
                }
            }
            finally {
                this.setCursor(Cursor.getDefaultCursor());
            }
            this.fileSelectPanel.closeArchive();
            JOptionPane.showMessageDialog(this, strings.getProperty("complete"));
            this.exitCode = exitCode;
            this.importedCharacterData = importedCharacterData;
            this.dispose();
        }
        catch (Exception ex) {
            ErrorMessageHelper.showErrorDialog(this, ex);
            this.updateBtnPanelState();
        }
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public CharacterData getImportedCharacterData() {
        return this.importedCharacterData;
    }

    protected CharacterData createNewProfile() throws IOException {
        BufferedImage samplePicture;
        CharacterData cd = this.fileSelectPanel.getCharacterData();
        if (cd == null || !cd.isValid()) {
            throw new IllegalStateException("imported caharcer data is invalid." + cd);
        }
        CharacterDataPersistent persist = CharacterDataPersistent.getInstance();
        CharacterData characterData = cd.duplicateBasicInfo(false);
        characterData.clearPartsSets(false);
        if (this.importTypeSelectPanel.isImportPreset()) {
            for (PartsSet partsSet : this.importPresetSelectPanel.getSelectedPartsSets()) {
                PartsSet ps = partsSet.clone();
                ps.setPresetParts(true);
                characterData.addPartsSet(ps);
            }
            characterData.setDefaultPartsSetId(this.importPresetSelectPanel.getPrefferedDefaultPartsSetId());
        }
        persist.createProfile(characterData);
        if (this.importTypeSelectPanel.isImportPartsImages()) {
            Collection<AbstractCharacterDataArchiveFile.PartsImageContent> partsImageContents = this.importPartsSelectPanel.getSelectedPartsImageContents();
            this.copyPartsImageContents(partsImageContents, characterData);
            PartsManageData partsManageData = this.fileSelectPanel.getPartsManageData();
            this.updatePartsManageData(partsImageContents, partsManageData, null, characterData);
        }
        if (this.importTypeSelectPanel.isImportSampleImage() && (samplePicture = this.fileSelectPanel.getSamplePicture()) != null) {
            persist.saveSamplePicture(characterData, samplePicture);
        }
        return characterData;
    }

    protected CharacterData updateProfile() throws IOException {
        BufferedImage samplePicture;
        if (this.current == null || !this.current.isValid()) {
            throw new IllegalStateException("current profile is not valid. :" + this.current);
        }
        CharacterDataPersistent persist = CharacterDataPersistent.getInstance();
        CharacterData characterData = this.current.duplicateBasicInfo(false);
        boolean imported = false;
        boolean modCharacterDef = false;
        boolean modFavories = false;
        if (this.importTypeSelectPanel.isImportPartsImages()) {
            Collection<AbstractCharacterDataArchiveFile.PartsImageContent> partsImageContents = this.importPartsSelectPanel.getSelectedPartsImageContents();
            this.copyPartsImageContents(partsImageContents, characterData);
            PartsManageData partsManageData = this.fileSelectPanel.getPartsManageData();
            this.updatePartsManageData(partsImageContents, partsManageData, characterData, characterData);
            imported = true;
        }
        if (this.importTypeSelectPanel.isImportSampleImage() && (samplePicture = this.fileSelectPanel.getSamplePicture()) != null) {
            persist.saveSamplePicture(characterData, samplePicture);
            imported = true;
        }
        if (this.importTypeSelectPanel.isImportPreset()) {
            for (PartsSet partsSet : this.importPresetSelectPanel.getSelectedPartsSets()) {
                PartsSet ps = partsSet.clone();
                ps.setPresetParts(false);
                characterData.addPartsSet(ps);
            }
            imported = true;
            modCharacterDef = true;
            modFavories = true;
        }
        if (this.importTypeSelectPanel.isAddDescription() && imported) {
            File archivedFile = this.fileSelectPanel.getFile();
            String note = this.importTypeSelectPanel.getAdditionalDescription();
            if (note != null && note.length() > 0) {
                String description = characterData.getDescription();
                if (description == null) {
                    description = "";
                }
                String lf = System.getProperty("line.separator");
                Timestamp tm = new Timestamp(System.currentTimeMillis());
                description = description + lf + "--- import: " + tm + " : " + archivedFile + " ---" + lf;
                description = description + note + lf;
                characterData.setDescription(description);
                modCharacterDef = true;
            }
        }
        if (modCharacterDef) {
            persist.updateProfile(characterData, false);
            this.current.setDescription(characterData.getDescription());
        }
        if (modFavories) {
            persist.saveFavorites(characterData);
        }
        return characterData;
    }

    protected void updatePartsManageData(Collection<AbstractCharacterDataArchiveFile.PartsImageContent> partsImageContents, PartsManageData partsManageData, CharacterData current, CharacterData target) throws IOException {
        if (target == null || !target.isValid()) {
            throw new IllegalArgumentException();
        }
        if (partsImageContents == null || partsImageContents.isEmpty() || partsManageData == null || partsManageData.isEmpty()) {
            return;
        }
        CharacterDataPersistent persist = CharacterDataPersistent.getInstance();
        PartsManageData mergedPartsManagedData = current != null && current.isValid() ? persist.loadPartsManageData(current.getDocBase()) : new PartsManageData();
        for (AbstractCharacterDataArchiveFile.PartsImageContent partsImageContent : partsImageContents) {
            String partsName = partsImageContent.getPartsName();
            for (AbstractCharacterDataArchiveFile.CategoryLayerPair catLayerPair : partsImageContent.getCategoryLayerPairs()) {
                PartsCategory partsCategory = catLayerPair.getPartsCategory();
                String categoryId = partsCategory.getCategoryId();
                PartsManageData.PartsKey partsKey = new PartsManageData.PartsKey(partsName, categoryId);
                PartsAuthorInfo partsAuthorInfo = partsManageData.getPartsAuthorInfo(partsKey);
                PartsManageData.PartsVersionInfo versionInfo = partsManageData.getVersion(partsKey);
                String localizedName = partsManageData.getLocalizedName(partsKey);
                if (partsAuthorInfo == null && versionInfo == null && localizedName == null) continue;
                mergedPartsManagedData.putPartsInfo(partsKey, localizedName, partsAuthorInfo, versionInfo);
            }
        }
        persist.savePartsManageData(target.getDocBase(), mergedPartsManagedData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyPartsImageContents(Collection<AbstractCharacterDataArchiveFile.PartsImageContent> partsImageContents, CharacterData cd) throws IOException {
        if (cd == null || cd.getDocBase() == null) {
            throw new IllegalArgumentException("invalid character data");
        }
        URL docbase = cd.getDocBase();
        if (!docbase.getProtocol().equals("file")) {
            throw new IOException("not file protocol: " + docbase);
        }
        File configFile = new File(docbase.getPath());
        File baseDir = configFile.getParentFile();
        if (baseDir == null || !baseDir.isDirectory()) {
            throw new IOException("not a directory. " + baseDir);
        }
        AppConfig appConfig = AppConfig.getInstance();
        byte[] stmbuf = new byte[appConfig.getFileTransferBufferSize()];
        for (AbstractCharacterDataArchiveFile.PartsImageContent content : partsImageContents) {
            BufferedInputStream is = new BufferedInputStream(content.openStream());
            try {
                File outDir = new File(baseDir, content.getDirName());
                outDir.mkdirs();
                File outFile = new File(outDir, content.getFileName());
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(outFile));
                try {
                    int rd;
                    while ((rd = ((InputStream)is).read(stmbuf)) >= 0) {
                        ((OutputStream)os).write(stmbuf, 0, rd);
                    }
                }
                finally {
                    ((OutputStream)os).close();
                }
                outFile.setLastModified(content.lastModified());
            }
            finally {
                ((InputStream)is).close();
            }
        }
    }
}

