/*
 * getopt.c - ChaSen version of getopt()
 *
 * Copyright (c) 1996,1997 Nara Institute of Science and Technology
 *
 * Author: A.Kitauchi <akira-k@is.aist-nara.ac.jp>, Apr 1997
 *
 */

#include <stdio.h>
#include <string.h>

int Cha_optind = 0;
char *Cha_optarg;

int cha_getopt(argv, optstring, fp)
    char **argv;
    char *optstring;
    FILE *fp;
{
    static char *nextchar;
    char *op, c;

    /* initialization */
    if (Cha_optind == 0) {
	Cha_optind = 1;
	nextchar = argv[1];
    }
    Cha_optarg = NULL;

    if (nextchar == argv[Cha_optind]) {
	/* no option */
	if (nextchar == NULL || nextchar[0] != '-' || nextchar[1] == '\0')
	  return EOF;
	/* '--' option */
	if (*++nextchar == '-') {
	    nextchar = argv[++Cha_optind];
	    return EOF;
	}
    }

    /* find out an option letter */
    c = *nextchar++;
    if ((op = strchr(optstring, c)) == NULL || c == ':') {
	if (fp != NULL)
	  fprintf(fp, "%s: invalid option -- %c\n", argv[0], c);
	c = '?';
    }
    /* option with an argument */
    else if (op[1] == ':') {
	/* next character */
	if (*nextchar)
	  Cha_optarg = nextchar;
	/* next argv */
	else if (argv[Cha_optind + 1] != NULL)
	  Cha_optarg = argv[++Cha_optind];
	/* no argument */
	else {
	    if (fp != NULL)
	      fprintf(fp, "%s: option requires an argument -- %c\n", argv[0], c);
	    c = '?';
	}
	nextchar = argv[++Cha_optind];
    }

    if (nextchar != NULL && *nextchar == '\0')
      nextchar = argv[++Cha_optind];

    return c;
}

/*
 * chasen_getopt
 */
int cha_getopt_chasen(argv, fp)
    char **argv;
    FILE *fp;
{
    return cha_getopt(argv, "sP:D:RabmpdvfecMo:F:L:l:jr:w:BChV", fp);
}

#ifdef TEST

int main (argc, argv)
    int argc;
    char **argv;
{
    int c;

    while (1)
      {
	  c = cha_getopt (argv, "abc:d:", stderr);
	  if (c == EOF)
	    break;
	  switch (c)
	    {
	      case 'a':
		printf ("option a\n");
		break;

	      case 'b':
		printf ("option b\n");
		break;

	      case 'c':
		printf ("option c with value `%s'\n", Cha_optarg);
		break;

	      case '?':
		break;

	      default:
		printf ("?? getopt returned character code 0%o ??\n", c);
	    }
      }

    if (Cha_optind < argc)
      {
	  printf ("non-option ARGV-elements: ");
	  while (Cha_optind < argc)
	    printf ("%s ", argv[Cha_optind++]);
	  printf ("\n");
      }

    exit (0);
}

#endif /* TEST */
