#!/bin/sh

#
# calc boot time and put them to /tmp/boot_time and /tmp/bios_time.
#     --- Okajima. 2010.
#


#
# boot time -> just uptime (= time after "uncompressing linux...").
# bios time -> TSC time (= time after power on ) - uptime.
#   -- Okajima.
#

calc_time()
{
	UPTIME=$(cat /proc/uptime)
	TSC=$(/tmp/usb/okajima/read_tsc)
	# SMP outs 2 lines of MHz.
	MHZ=$(grep "cpu MHz" /proc/cpuinfo | awk '{print $4}' | head -1 )
	BOOT_TIME=$(echo $UPTIME | cut -d " " -f 1)
	BOOT_TIME_TSC=$(echo "scale=2; $TSC / $MHZ / 1000 / 1000" | bc)
	BIOS_TIME=$(echo "scale=2; $BOOT_TIME_TSC - $BOOT_TIME" | bc)
	echo $BOOT_TIME >/tmp/boot_time
	echo $BIOS_TIME >/tmp/bios_time
	echo "CHROMIUM BOOT $(cat /tmp/boot_time) BIOS $(cat /tmp/bios_time)" >/dev/kmsg
}

doit()
{
	[ -f /tmp/boot_time ] || calc_time
	#echo "BOOT: $(cat /tmp/boot_time)"
	#echo "BIOS: $(cat /tmp/bios_time)"
}

doit

