#!/bin/sh

ERR()
{
	echo ERR $*
	/bin/bash
	exit 1
}



# Why linux kernel developer uses "[]"?
normalize()
{
	local a b c d e
	sed 's/]/ /g' |
	sed 's/\[/ /g' |
	while read a b c d e
	do
		echo $a $b $c $d $e
	done
}


out_stat()
{
	local cpu cpu0 cpu1 cpu_out cpu0_out cpu1_out disk
	cpu=$(($CPU_TOTAL - $IDLE))
	cpu_out=$(($cpu * 100 / $CPU_TOTAL ))
	if [ -n "$CPU0_TOTAL" ]
	then
		cpu0=$(($CPU0_TOTAL - $IDLE0))
		cpu0_out=$(($cpu0 * 100 / $CPU0_TOTAL ))
	fi
	if [ -n "$CPU1_TOTAL" ]
	then
		cpu1=$(($CPU1_TOTAL - $IDLE1))
		cpu1_out=$(($cpu1 * 100 / $CPU1_TOTAL ))
	fi
	[ -n "$cpu0_out" ] || cpu0_out=0
	[ -n "$cpu1_out" ] || cpu1_out=0
	disk=$(echo "scale=2;$SECTORS_READ*512/$DISKSTATS_TIME/1000/1000" | bc)
	printf \
	"CPU total %3d cpu0 %3d cpu1 %3d DISK %s" \
	$cpu_out $cpu0_out $cpu1_out $disk
}

format()
{
	local first rest
	while read first rest
	do
		printf "[%12f] " $first
		echo "$rest"
	done
}

doit_sub()
{
	local a b c d e f g h i j k l m n
	normalize |
	while read a b c d e f g h i j k l m d0 e0 f0 g0 h0 i0 j0 k0 l0 m0 d1 e1 f1 g1 h1 i1 j1 k1 l1 m1 n
	do
		case "$c" in
		"STAT1")
			[ $d = "cpu" ] || ERR
			USER=$(($e-$USER_OLD))
			NICE=$(($f-$NICE_OLD))
			SYS=$(($g-$SYS_OLD))
			IDLE=$(($h-$IDLE_OLD))
			IOWAIT=$(($i-$IOWAIT_OLD))
			IRQ=$(($j-$IRQ_OLD))
			SOFTIRQ=$(($k-$SOFTIRQ_OLD))
			STEAL=$(($l-$STEAL_OLD))
			GUEST=$(($m-$GUEST_OLD))
			CPU_TOTAL=$(($USER+$NICE+$SYS+$IDLE+$IOWAIT+$IRQ+$SOFTIRQ+$STEAL+$GUEST))
			USER_OLD=$e
			NICE_OLD=$f
			SYS_OLD=$g
			IDLE_OLD=$h
			IOWAIT_OLD=$i
			IRQ_OLD=$j
			SOFTIRQ_OLD=$k
			STEAL_OLD=$l
			GUEST_OLD=$m
			
			if [ "$d0" = "cpu0" ]
			then
				USER0=$(($e0-$USER0_OLD))
				NICE0=$(($f0-$NICE0_OLD))
				SYS0=$(($g0-$SYS0_OLD))
				IDLE0=$(($h0-$IDLE0_OLD))
				IOWAIT0=$(($i0-$IOWAIT0_OLD))
				IRQ0=$(($j0-$IRQ0_OLD))
				SOFTIRQ0=$(($k0-$SOFTIRQ0_OLD))
				STEAL0=$(($l0-$STEAL0_OLD))
				GUEST0=$(($m0-$GUEST0_OLD))
				CPU0_TOTAL=$(($USER0+$NICE0+$SYS0+$IDLE0+$IOWAIT0+$IRQ0+$SOFTIRQ0+$STEAL0+$GUEST0))
				USER0_OLD=$e0
				NICE0_OLD=$f0
				SYS0_OLD=$g0
				IDLE0_OLD=$h0
				IOWAIT0_OLD=$i0
				IRQ0_OLD=$j0
				SOFTIRQ0_OLD=$k0
				STEAL0_OLD=$l0
				GUEST0_OLD=$m0
			fi
			
			if [ "$d1" = "cpu1" ]
			then
				USER1=$(($e1-$USER1_OLD))
				NICE1=$(($f1-$NICE1_OLD))
				SYS1=$(($g1-$SYS1_OLD))
				IDLE1=$(($h1-$IDLE1_OLD))
				IOWAIT1=$(($i1-$IOWAIT1_OLD))
				IRQ1=$(($j1-$IRQ1_OLD))
				SOFTIRQ1=$(($k1-$SOFTIRQ1_OLD))
				STEAL1=$(($l1-$STEAL1_OLD))
				GUEST1=$(($m1-$GUEST1_OLD))
				CPU1_TOTAL=$(($USER1+$NICE1+$SYS1+$IDLE1+$IOWAIT1+$IRQ1+$SOFTIRQ1+$STEAL1+$GUEST1))
				USER1_OLD=$e1
				NICE1_OLD=$f1
				SYS1_OLD=$g1
				IDLE1_OLD=$h1
				IOWAIT1_OLD=$i1
				IRQ1_OLD=$j1
				SOFTIRQ1_OLD=$k1
				STEAL1_OLD=$l1
				GUEST1_OLD=$m1
			fi
			;;
		"STAT2")
			DISKSTATS_TIME=$(echo "$a - $DISKSTATS_TIME_OLD" | bc)
			DISKSTATS_TIME_OLD=$a
			SECTORS_READ=$(($i-$SECTORS_READ_OLD))
			SECTORS_READ_OLD=$i
			echo $a $b "$(out_stat)"
			;;
		*)
			echo $a $b $c $d $e $f $g $h $i $j $k $l $m $d0 $e0 $f0 $g0 $h0 $i0 $j0 $k0 $l0 $m0 $d1 $e1 $f1 $g1 $h1 $i1 $j1 $k1 $l1 $m1 $n
			;;
		esac
	done
}



init()
{
	USER=0
	NICE=0
	SYS=0
	IDLE=0
	IOWAIT=0
	IRQ=0
	SOFTIRQ=0
	STEAL=0
	GUEST=0
	
	USER_OLD=0
	NICE_OLD=0
	SYS_OLD=0
	IDLE_OLD=0
	IOWAIT_OLD=0
	IRQ_OLD=0
	SOFTIRQ_OLD=0
	STEAL_OLD=0
	GUEST_OLD=0
	
	USER0=0
	NICE0=0
	SYS0=0
	IDLE0=0
	IOWAIT0=0
	IRQ0=0
	SOFTIRQ0=0
	STEAL0=0
	GUEST0=0
	
	USER0_OLD=0
	NICE0_OLD=0
	SYS0_OLD=0
	IDLE0_OLD=0
	IOWAIT0_OLD=0
	IRQ0_OLD=0
	SOFTIRQ0_OLD=0
	STEAL0_OLD=0
	GUEST0_OLD=0
	
	USER1=0
	NICE1=0
	SYS1=0
	IDLE1=0
	IOWAIT1=0
	IRQ1=0
	SOFTIRQ1=0
	STEAL1=0
	GUEST1=0
	
	USER1_OLD=0
	NICE1_OLD=0
	SYS1_OLD=0
	IDLE1_OLD=0
	IOWAIT1_OLD=0
	IRQ1_OLD=0
	SOFTIRQ1_OLD=0
	STEAL1_OLD=0
	GUEST1_OLD=0
	
	
	SECTORS_READ=0
	SECTORS_READ_OLD=0
	DISKSTATS_TIME_OLD=0
}

doit()
{
	doit_sub | format
}

init
doit

