/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.math.BigDecimal;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionValue;
import org.hsqldb.HsqlException;
import org.hsqldb.Scanner;
import org.hsqldb.Token;
import org.hsqldb.Tokens;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntKeyIntValueHashMap;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class ParserBase {
    private Scanner scanner;
    protected Token token;
    protected boolean isRecording;
    protected HsqlArrayList recordedStatement;
    private final Token dummyToken = new Token();
    protected boolean isCheckOrTriggerCondition;
    protected boolean isSchemaDefinition;
    protected int parsePosition;
    static final BigDecimal LONG_MAX_VALUE_INCREMENT = BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.valueOf(1L));
    private static final IntKeyIntValueHashMap expressionTypeMap = new IntKeyIntValueHashMap(37);

    ParserBase(Scanner scanner) {
        this.scanner = scanner;
        this.token = this.scanner.token;
    }

    public Scanner getScanner() {
        return this.scanner;
    }

    public int getParsePosition() {
        return this.parsePosition;
    }

    public void setParsePosition(int n) {
        this.parsePosition = n;
    }

    void reset(String string) {
        this.scanner.reset(string);
        this.parsePosition = 0;
        this.isCheckOrTriggerCondition = false;
        this.isSchemaDefinition = false;
        this.isRecording = false;
        this.recordedStatement = null;
    }

    int getPosition() {
        return this.scanner.getTokenPosition();
    }

    void rewind(int n) {
        if (n == this.scanner.getTokenPosition()) {
            return;
        }
        this.scanner.position(n);
        if (this.isRecording) {
            int n2;
            for (n2 = this.recordedStatement.size() - 1; n2 >= 0; --n2) {
                Token token = (Token)this.recordedStatement.get(n2);
                if (token.position < n) break;
            }
            this.recordedStatement.setSize(n2 + 1);
        }
        this.read();
    }

    String getLastPart() {
        return this.scanner.getPart(this.parsePosition, this.scanner.getTokenPosition());
    }

    String getLastPart(int n) {
        return this.scanner.getPart(n, this.scanner.getTokenPosition());
    }

    String getLastPartAndCurrent(int n) {
        return this.scanner.getPart(n, this.scanner.getPosition());
    }

    String getStatement(int n, short[] sArray) {
        while (this.token.tokenType != 791 && this.token.tokenType != 848 && ArrayUtil.find(sArray, this.token.tokenType) == -1) {
            this.read();
        }
        String string = this.scanner.getPart(n, this.scanner.getTokenPosition());
        return string;
    }

    String getStatementForRoutine(int n, short[] sArray) {
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        while (true) {
            if (this.token.tokenType == 791) {
                n4 = this.scanner.getTokenPosition();
                n3 = n2;
            } else {
                if (this.token.tokenType == 848) {
                    if (n3 <= 0 || n3 != n2 - 1) break;
                    this.rewind(n4);
                    break;
                }
                if (ArrayUtil.find(sArray, this.token.tokenType) != -1) break;
            }
            this.read();
            ++n2;
        }
        String string = this.scanner.getPart(n, this.scanner.getTokenPosition());
        return string;
    }

    void startRecording() {
        this.recordedStatement = new HsqlArrayList();
        this.recordedStatement.add(this.token.duplicate());
        this.isRecording = true;
    }

    Token getRecordedToken() {
        if (this.isRecording) {
            return (Token)this.recordedStatement.get(this.recordedStatement.size() - 1);
        }
        return this.dummyToken;
    }

    Token[] getRecordedStatement() {
        this.isRecording = false;
        this.recordedStatement.remove(this.recordedStatement.size() - 1);
        Token[] tokenArray = new Token[this.recordedStatement.size()];
        this.recordedStatement.toArray(tokenArray);
        this.recordedStatement = null;
        return tokenArray;
    }

    void read() {
        this.scanner.scanNext();
        if (this.token.isMalformed) {
            int n = -1;
            switch (this.token.tokenType) {
                case 856: {
                    n = 5587;
                    break;
                }
                case 855: {
                    n = 5588;
                    break;
                }
                case 857: {
                    n = 5586;
                    break;
                }
                case 853: {
                    n = 5584;
                    break;
                }
                case -1: {
                    n = 5582;
                    break;
                }
                case 854: {
                    n = 5585;
                    break;
                }
                case 858: {
                    n = 5589;
                    break;
                }
                case 859: {
                    n = 5583;
                }
            }
            throw Error.error(n);
        }
        if (this.isRecording) {
            Token token = this.token.duplicate();
            token.position = this.scanner.getTokenPosition();
            this.recordedStatement.add(token);
        }
    }

    boolean isReservedKey() {
        return this.scanner.token.isReservedIdentifier;
    }

    boolean isCoreReservedKey() {
        return this.scanner.token.isCoreReservedIdentifier;
    }

    boolean isNonReservedIdentifier() {
        return !this.scanner.token.isReservedIdentifier && (this.scanner.token.isUndelimitedIdentifier || this.scanner.token.isDelimitedIdentifier);
    }

    void checkIsNonReservedIdentifier() {
        if (!this.isNonReservedIdentifier()) {
            throw this.unexpectedToken();
        }
    }

    boolean isNonCoreReservedIdentifier() {
        return !this.scanner.token.isCoreReservedIdentifier && (this.scanner.token.isUndelimitedIdentifier || this.scanner.token.isDelimitedIdentifier);
    }

    void checkIsNonCoreReservedIdentifier() {
        if (!this.isNonCoreReservedIdentifier()) {
            throw this.unexpectedToken();
        }
    }

    boolean isIdentifier() {
        return this.scanner.token.isUndelimitedIdentifier || this.scanner.token.isDelimitedIdentifier;
    }

    void checkIsIdentifier() {
        if (!this.isIdentifier()) {
            throw this.unexpectedToken();
        }
    }

    boolean isDelimitedIdentifier() {
        return this.scanner.token.isDelimitedIdentifier;
    }

    void checkIsDelimitedIdentifier() {
        if (this.token.tokenType != 847) {
            throw Error.error(5569);
        }
    }

    void checkIsNotQuoted() {
        if (this.token.tokenType == 847) {
            throw this.unexpectedToken();
        }
    }

    void checkIsValue() {
        if (this.token.tokenType != 845) {
            throw this.unexpectedToken();
        }
    }

    void checkIsValue(int n) {
        if (this.token.tokenType != 845 || this.token.dataType.typeCode != n) {
            throw this.unexpectedToken();
        }
    }

    void checkIsThis(int n) {
        if (this.token.tokenType != n) {
            throw this.unexpectedToken();
        }
    }

    boolean isUndelimitedSimpleName() {
        return this.token.isUndelimitedIdentifier && this.token.namePrefix == null;
    }

    boolean isDelimitedSimpleName() {
        return this.token.isDelimitedIdentifier && this.token.namePrefix == null;
    }

    boolean isSimpleName() {
        return this.isNonCoreReservedIdentifier() && this.token.namePrefix == null;
    }

    void checkIsSimpleName() {
        if (!this.isSimpleName()) {
            throw this.unexpectedToken();
        }
    }

    void readUnquotedIdentifier(String string) {
        this.checkIsSimpleName();
        if (!this.token.tokenString.equals(string)) {
            throw this.unexpectedToken();
        }
        this.read();
    }

    String readQuotedString() {
        this.checkIsValue();
        if (this.token.dataType.typeCode != 1) {
            throw Error.error(5563);
        }
        String string = this.token.tokenString;
        this.read();
        return string;
    }

    void readThis(int n) {
        if (this.token.tokenType != n) {
            String string = Tokens.getKeyword(n);
            throw this.unexpectedTokenRequire(string);
        }
        this.read();
    }

    boolean readIfThis(int n) {
        if (this.token.tokenType == n) {
            this.read();
            return true;
        }
        return false;
    }

    Integer readIntegerObject() {
        int n = this.readInteger();
        return ValuePool.getInt(n);
    }

    int readInteger() {
        boolean bl = false;
        if (this.token.tokenType == 784) {
            bl = true;
            this.read();
        }
        this.checkIsValue();
        if (bl && this.token.dataType.typeCode == 25 && ((Number)this.token.tokenValue).longValue() == 0x80000000L) {
            this.read();
            return Integer.MIN_VALUE;
        }
        if (this.token.dataType.typeCode != 4) {
            throw Error.error(5563);
        }
        int n = ((Number)this.token.tokenValue).intValue();
        if (bl) {
            n = -n;
        }
        this.read();
        return n;
    }

    long readBigint() {
        boolean bl = false;
        if (this.token.tokenType == 784) {
            bl = true;
            this.read();
        }
        this.checkIsValue();
        if (bl && this.token.dataType.typeCode == 2 && LONG_MAX_VALUE_INCREMENT.equals(this.token.tokenValue)) {
            this.read();
            return Long.MIN_VALUE;
        }
        if (this.token.dataType.typeCode != 4 && this.token.dataType.typeCode != 25) {
            throw Error.error(5563);
        }
        long l = ((Number)this.token.tokenValue).longValue();
        if (bl) {
            l = -l;
        }
        this.read();
        return l;
    }

    Expression readDateTimeIntervalLiteral() {
        int n = this.getPosition();
        switch (this.token.tokenType) {
            case 72: {
                this.read();
                if (this.token.tokenType != 845 || this.token.dataType.typeCode != 1) break;
                String string = this.token.tokenString;
                this.read();
                TimestampData timestampData = this.scanner.newDate(string);
                return new ExpressionValue(timestampData, Type.SQL_DATE);
            }
            case 281: {
                this.read();
                if (this.token.tokenType != 845 || this.token.dataType.typeCode != 1) break;
                String string = this.token.tokenString;
                this.read();
                TimeData timeData = this.scanner.newTime(string);
                Type type = this.scanner.dateTimeType;
                return new ExpressionValue(timeData, type);
            }
            case 282: {
                this.read();
                if (this.token.tokenType != 845 || this.token.dataType.typeCode != 1) break;
                String string = this.token.tokenString;
                this.read();
                TimestampData timestampData = this.scanner.newTimestamp(string);
                Type type = this.scanner.dateTimeType;
                return new ExpressionValue(timestampData, type);
            }
            case 140: {
                boolean bl = false;
                this.read();
                if (this.token.tokenType == 784) {
                    this.read();
                    bl = true;
                } else if (this.token.tokenType == 787) {
                    this.read();
                }
                if (this.token.tokenType != 845 || this.token.dataType.typeCode != 1) break;
                String string = this.token.tokenString;
                this.read();
                IntervalType intervalType = this.readIntervalType(false);
                Object object = this.scanner.newInterval(string, intervalType);
                intervalType = (IntervalType)this.scanner.dateTimeType;
                if (bl) {
                    object = intervalType.negate(object);
                }
                return new ExpressionValue(object, intervalType);
            }
            default: {
                throw Error.runtimeError(201, "ParserBase");
            }
        }
        this.rewind(n);
        return null;
    }

    IntervalType readIntervalType(boolean bl) {
        int n;
        int n2 = bl ? 9 : -1;
        int n3 = -1;
        int n4 = n = this.token.tokenType;
        this.read();
        if (this.token.tokenType == 786) {
            this.read();
            n2 = this.readInteger();
            if (n2 <= 0) {
                throw Error.error(5592);
            }
            if (this.token.tokenType == 774) {
                if (n4 != 250) {
                    throw this.unexpectedToken();
                }
                this.read();
                n3 = this.readInteger();
                if (n3 < 0) {
                    throw Error.error(5592);
                }
            }
            this.readThis(772);
        }
        if (this.token.tokenType == 285) {
            this.read();
            n = this.token.tokenType;
            this.read();
        }
        if (this.token.tokenType == 786) {
            if (n != 250 || n == n4) {
                throw this.unexpectedToken();
            }
            this.read();
            n3 = this.readInteger();
            if (n3 < 0) {
                throw Error.error(5592);
            }
            this.readThis(772);
        }
        int n5 = ArrayUtil.find(Tokens.SQL_INTERVAL_FIELD_CODES, n4);
        int n6 = ArrayUtil.find(Tokens.SQL_INTERVAL_FIELD_CODES, n);
        return IntervalType.getIntervalType(n5, n6, n2, n3);
    }

    static int getExpressionType(int n) {
        int n2 = expressionTypeMap.get(n, -1);
        if (n2 == -1) {
            throw Error.runtimeError(201, "ParserBase");
        }
        return n2;
    }

    HsqlException unexpectedToken(String string) {
        return Error.parseError(5581, string, this.scanner.getLineNumber());
    }

    HsqlException unexpectedTokenRequire(String string) {
        if (this.token.tokenType == 848) {
            return Error.parseError(5590, 1, this.scanner.getLineNumber(), new Object[]{"", string});
        }
        String string2 = this.token.charsetSchema != null ? this.token.charsetSchema : (this.token.charsetName != null ? this.token.charsetName : (this.token.namePrePrefix != null ? this.token.namePrePrefix : (this.token.namePrefix != null ? this.token.namePrefix : this.token.tokenString)));
        return Error.parseError(5581, 1, this.scanner.getLineNumber(), new Object[]{string2, string});
    }

    HsqlException unexpectedToken() {
        if (this.token.tokenType == 848) {
            return Error.parseError(5590, null, this.scanner.getLineNumber());
        }
        String string = this.token.charsetSchema != null ? this.token.charsetSchema : (this.token.charsetName != null ? this.token.charsetName : (this.token.namePrePrefix != null ? this.token.namePrePrefix : (this.token.namePrefix != null ? this.token.namePrefix : this.token.tokenString)));
        return Error.parseError(5581, string, this.scanner.getLineNumber());
    }

    HsqlException tooManyIdentifiers() {
        String string = this.token.namePrePrePrefix != null ? this.token.namePrePrePrefix : (this.token.namePrePrefix != null ? this.token.namePrePrefix : (this.token.namePrefix != null ? this.token.namePrefix : this.token.tokenString));
        return Error.parseError(5551, string, this.scanner.getLineNumber());
    }

    HsqlException unsupportedFeature() {
        return Error.error(1551, this.token.tokenString);
    }

    HsqlException unsupportedFeature(String string) {
        return Error.error(1551, string);
    }

    public Number convertToNumber(String string, NumberType numberType) {
        return this.scanner.convertToNumber(string, numberType);
    }

    static {
        expressionTypeMap.put(396, 41);
        expressionTypeMap.put(779, 43);
        expressionTypeMap.put(782, 44);
        expressionTypeMap.put(780, 42);
        expressionTypeMap.put(783, 45);
        expressionTypeMap.put(785, 46);
        expressionTypeMap.put(52, 71);
        expressionTypeMap.put(163, 74);
        expressionTypeMap.put(168, 73);
        expressionTypeMap.put(274, 72);
        expressionTypeMap.put(16, 75);
        expressionTypeMap.put(97, 76);
        expressionTypeMap.put(6, 77);
        expressionTypeMap.put(258, 77);
        expressionTypeMap.put(269, 78);
        expressionTypeMap.put(270, 79);
        expressionTypeMap.put(309, 80);
        expressionTypeMap.put(310, 81);
        expressionTypeMap.put(9, 82);
        expressionTypeMap.put(682, 83);
        expressionTypeMap.put(605, 85);
    }
}

