/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.common.api.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import jp.co.ogis_ri.citk.policytool.common.api.OpenAMAccess;
import jp.co.ogis_ri.citk.policytool.common.api.impl.OpenAMModelContext;
import jp.co.ogis_ri.citk.policytool.common.api.impl.OpenAMPoliciesBuilder;
import jp.co.ogis_ri.citk.policytool.common.api.impl.PoliciesBuilder;
import jp.co.ogis_ri.citk.policytool.common.api.impl.RealmsBuilder;
import jp.co.ogis_ri.citk.policytool.common.api.impl.model.OpenAMPolicies;
import jp.co.ogis_ri.citk.policytool.common.api.impl.ssoadm.SsoadmClient;
import jp.co.ogis_ri.citk.policytool.common.api.impl.ssoadm.SsoadmResult;
import jp.co.ogis_ri.citk.policytool.common.exception.OpenAMAccessException;
import jp.co.ogis_ri.citk.policytool.common.http.HttpClientWrapper;
import jp.co.ogis_ri.citk.policytool.common.logging.LogWrapperFactory;
import jp.co.ogis_ri.citk.policytool.common.util.StreamUtil;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Realm;
import org.apache.commons.logging.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class OpenAMAccessImpl
implements OpenAMAccess {
    private final Log operationLogger = LogWrapperFactory.getOperationLog();
    @Autowired(required=false)
    @Qualifier(value="policytoolProperty")
    private Properties props = null;

    public OpenAMAccessImpl() {
    }

    public OpenAMAccessImpl(Properties props) {
        this.props = props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Realm> getRealms(String realmName, String filter) {
        this.operationLogger.info((Object)("getRealms " + realmName + ", " + filter));
        List<Realm> realms = null;
        RealmsBuilder builder = new RealmsBuilder();
        HttpClientWrapper httpClient = new HttpClientWrapper();
        SsoadmClient ssoadmClient = this.createSsoadmClient(httpClient);
        try {
            SsoadmResult realmResult = ssoadmClient.getRealms(realmName, filter, false);
            if (realmResult.getExitCode() != 0) {
                throw new OpenAMAccessException(realmResult.getExitCode(), "E-0004", realmResult.getExitCode());
            }
            builder.addRealms(realmResult.getData());
            for (String name : realmResult.getData()) {
                SsoadmResult groupResult = ssoadmClient.getGroup(name, "*");
                if (groupResult.getExitCode() != 0) {
                    throw new OpenAMAccessException(groupResult.getExitCode(), "E-0004", groupResult.getExitCode());
                }
                builder.addGroups(name, groupResult.getData());
            }
            SsoadmResult policiesResult = ssoadmClient.getPolicies("/", "*");
            if (policiesResult.getExitCode() != 0) {
                throw new OpenAMAccessException(policiesResult.getExitCode(), "E-0004", policiesResult.getExitCode());
            }
            OpenAMPolicies amPolicies = this.toOpenAMPolicies(policiesResult.getData().get(0).getBytes());
            builder.addPolicies(amPolicies);
            realms = builder.build();
        }
        finally {
            httpClient.shutdown();
        }
        this.operationLogger.info((Object)realms.toString());
        return realms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Policy> getPolicies(String realmName, String policyName) {
        this.operationLogger.info((Object)("getPolicies " + realmName + ", " + policyName));
        List<Policy> policies = null;
        PoliciesBuilder builder = new PoliciesBuilder();
        HttpClientWrapper httpClient = new HttpClientWrapper();
        SsoadmClient ssoadmClient = this.createSsoadmClient(httpClient);
        try {
            SsoadmResult result = ssoadmClient.getPolicies(realmName, policyName);
            if (result.getExitCode() != 0) {
                throw new OpenAMAccessException(result.getExitCode(), "E-0004", result.getExitCode());
            }
            OpenAMPolicies amPolicies = this.toOpenAMPolicies(result.getData().get(0).getBytes());
            builder.add(realmName, amPolicies);
            policies = builder.build();
        }
        finally {
            httpClient.shutdown();
        }
        for (Policy policy : policies) {
            this.operationLogger.info((Object)policy.toString());
        }
        return policies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createPolicy(Policy policy) {
        this.operationLogger.info((Object)("createPolicy " + policy.toString()));
        HttpClientWrapper httpClient = new HttpClientWrapper();
        SsoadmClient ssoadmClient = this.createSsoadmClient(httpClient);
        try {
            String xml = this.toXml(policy);
            SsoadmResult result = ssoadmClient.createPolicies(policy.getRealmName(), xml);
            if (result.getExitCode() != 0) {
                throw new OpenAMAccessException(result.getExitCode(), "E-0004", result.getExitCode());
            }
        }
        finally {
            httpClient.shutdown();
        }
    }

    @Override
    public void updatePolicy(Policy policy) {
        this.operationLogger.info((Object)("updatePolicy " + policy.toString()));
        this.deletePolicy(policy);
        this.createPolicy(policy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deletePolicy(Policy policy) {
        this.operationLogger.info((Object)("deletePolicy " + policy.toString()));
        HttpClientWrapper httpClient = new HttpClientWrapper();
        SsoadmClient ssoadmClient = this.createSsoadmClient(httpClient);
        try {
            SsoadmResult result = ssoadmClient.deletePolicy(policy.getRealmName(), policy.getPolicyName());
            if (result.getExitCode() != 0) {
                throw new OpenAMAccessException(result.getExitCode(), "E-0004", result.getExitCode());
            }
        }
        finally {
            httpClient.shutdown();
        }
    }

    private SsoadmClient createSsoadmClient(HttpClientWrapper httpClient) {
        httpClient.setEncoding(this.props.getProperty("openam.encoding"));
        return new SsoadmClient(httpClient, this.props.getProperty("openam.ssoadm.url"), this.props.getProperty("openam.userid"), this.props.getProperty("openam.password"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OpenAMPolicies toOpenAMPolicies(byte[] xml) {
        OpenAMPolicies amPolicies = null;
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(xml);
            OpenAMModelContext.setJaxbEncoding(this.props.getProperty("openam.encoding"));
            amPolicies = OpenAMModelContext.unmarshaller(OpenAMPolicies.class, is);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {}
            }
        }
        return amPolicies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toXml(Policy policy) {
        String xml = null;
        ByteArrayOutputStream os = null;
        OpenAMPoliciesBuilder builder = new OpenAMPoliciesBuilder();
        builder.addPolicy(policy);
        OpenAMPolicies amPolicies = builder.build();
        try {
            os = new ByteArrayOutputStream();
            OpenAMModelContext.setJaxbEncoding(this.props.getProperty("openam.encoding"));
            OpenAMModelContext.marshaller(amPolicies, os);
            xml = StreamUtil.toString(new ByteArrayInputStream(os.toByteArray()));
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {}
            }
        }
        return xml;
    }
}

