/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.common.api.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import jp.co.ogis_ri.citk.policytool.common.api.impl.model.OpenAMPolicies;
import jp.co.ogis_ri.citk.policytool.common.logging.LogWrapperFactory;
import jp.co.ogis_ri.citk.policytool.common.util.ExceptionUtil;
import org.apache.commons.logging.Log;

class OpenAMModelContext {
    private static final Log logger = LogWrapperFactory.getLog(OpenAMModelContext.class);
    private static final String DTD_OPENAM_POLICIES = "<!DOCTYPE Policies PUBLIC \"-//OpenSSO Policy Administration DTD//EN\" \"jar://com/sun/identity/policy/policyAdmin.dtd\">";
    private static final String XML_DEFINITION = "<?xml version=\"1.0\" encoding=\"{0}\"?>";
    private static JAXBContext context = null;
    private static Marshaller marshaller = null;
    private static Unmarshaller unmarshaller = null;
    private static String jaxbEncoding = "UTF-8";
    private static boolean jaxbFormatOutput = false;

    public static String getJaxbEncoding() {
        return jaxbEncoding;
    }

    public static void setJaxbEncoding(String jaxbEncoding) {
        if (marshaller != null) {
            try {
                marshaller.setProperty("jaxb.encoding", (Object)jaxbEncoding);
            }
            catch (PropertyException e) {
                logger.debug((Object)e.getMessage());
                throw ExceptionUtil.convertRuntimeException(e);
            }
        }
        OpenAMModelContext.jaxbEncoding = jaxbEncoding;
    }

    public static boolean isJaxbFormatoutput() {
        return jaxbFormatOutput;
    }

    public static void setJaxbFormatOutput(boolean jaxbFormatOutput) {
        if (marshaller != null) {
            try {
                marshaller.setProperty("jaxb.formatted.output", (Object)jaxbFormatOutput);
            }
            catch (PropertyException e) {
                logger.debug((Object)e.getMessage());
                throw ExceptionUtil.convertRuntimeException(e);
            }
        }
        OpenAMModelContext.jaxbFormatOutput = jaxbFormatOutput;
    }

    private OpenAMModelContext() {
    }

    public static void marshaller(OpenAMPolicies jaxbElement, OutputStream outputStream) {
        String lineSeparator = System.getProperty("line.separator");
        BufferedOutputStream stream = new BufferedOutputStream(outputStream);
        try {
            OpenAMModelContext.initContext();
            String xmldef = MessageFormat.format(XML_DEFINITION, jaxbEncoding);
            stream.write((xmldef + lineSeparator).getBytes());
            stream.write((DTD_OPENAM_POLICIES + lineSeparator).getBytes());
            marshaller.marshal((Object)jaxbElement, (OutputStream)stream);
            stream.close();
        }
        catch (JAXBException e) {
            logger.debug((Object)e.getMessage());
            throw ExceptionUtil.convertRuntimeException(e);
        }
        catch (IOException e) {
            logger.debug((Object)e.getMessage());
            throw ExceptionUtil.convertRuntimeException(e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {}
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static <T> T unmarshaller(Class<T> clazz, InputStream reader) {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        BufferedInputStream stream = new BufferedInputStream(reader);
        XMLStreamReader xmlStreamReader = null;
        try {
            xmlStreamReader = factory.createXMLStreamReader(stream);
        }
        catch (XMLStreamException e) {
            logger.debug((Object)e.getMessage());
            throw ExceptionUtil.convertRuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        return OpenAMModelContext.unmarshaller(clazz, xmlStreamReader);
    }

    public static <T> T unmarshaller(Class<T> clazz, XMLStreamReader xmlStreamReader) {
        T result = null;
        try {
            OpenAMModelContext.initContext();
            result = clazz.cast(unmarshaller.unmarshal(xmlStreamReader));
        }
        catch (JAXBException e) {
            logger.debug((Object)e.getMessage());
            throw ExceptionUtil.convertRuntimeException(e);
        }
        finally {
            if (xmlStreamReader != null) {
                try {
                    xmlStreamReader.close();
                }
                catch (XMLStreamException e) {}
            }
        }
        return result;
    }

    private static void initContext() throws JAXBException {
        if (context == null) {
            context = JAXBContext.newInstance((String)OpenAMPolicies.class.getPackage().getName());
            marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)jaxbEncoding);
            marshaller.setProperty("jaxb.formatted.output", (Object)jaxbFormatOutput);
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            unmarshaller = context.createUnmarshaller();
        }
    }
}

