/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.common.api.impl;

import java.util.ArrayList;
import java.util.List;
import jp.co.ogis_ri.citk.policytool.common.api.impl.model.OpenAMAttribute;
import jp.co.ogis_ri.citk.policytool.common.api.impl.model.OpenAMAttributeValuePair;
import jp.co.ogis_ri.citk.policytool.common.api.impl.model.OpenAMPolicies;
import jp.co.ogis_ri.citk.policytool.common.api.impl.model.OpenAMPolicy;
import jp.co.ogis_ri.citk.policytool.common.api.impl.model.OpenAMResourceName;
import jp.co.ogis_ri.citk.policytool.common.api.impl.model.OpenAMRule;
import jp.co.ogis_ri.citk.policytool.common.api.impl.model.OpenAMServiceName;
import jp.co.ogis_ri.citk.policytool.common.api.impl.model.OpenAMSubject;
import jp.co.ogis_ri.citk.policytool.common.api.impl.model.OpenAMSubjects;
import jp.co.ogis_ri.citk.policytool.common.util.OpenAMNamingUtil;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Permit;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Resource;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Subject;

class OpenAMPoliciesBuilder {
    private List<Policy> policyList = new ArrayList<Policy>();

    public void addPolicy(Policy policy) {
        this.policyList.add(policy);
    }

    public OpenAMPolicies build() {
        OpenAMPolicies openAMPolicies = new OpenAMPolicies();
        for (Policy policy : this.policyList) {
            OpenAMPolicy openAMPolicy = this.createPolicy(policy);
            openAMPolicies.getPolicy().add(openAMPolicy);
        }
        return openAMPolicies;
    }

    private OpenAMPolicy createPolicy(Policy policy) {
        OpenAMPolicy openAMPolicy = new OpenAMPolicy();
        openAMPolicy.setName(policy.getPolicyName());
        openAMPolicy.setDescription("");
        openAMPolicy.setReferralPolicy(false);
        openAMPolicy.setActive(true);
        for (Resource resource : policy.getResources()) {
            openAMPolicy.getRule().add(this.createRule(resource));
        }
        openAMPolicy.setSubjects(this.createSubjects(policy.getSubjects()));
        return openAMPolicy;
    }

    private OpenAMRule createRule(Resource resource) {
        Permit getPermit;
        OpenAMRule ruleBean = new OpenAMRule();
        ruleBean.setName(OpenAMNamingUtil.generateRuleName());
        OpenAMServiceName serviceNameBean = new OpenAMServiceName();
        serviceNameBean.setName("iPlanetAMWebAgentService");
        ruleBean.setServiceName(serviceNameBean);
        OpenAMResourceName resourceNameBean = new OpenAMResourceName();
        resourceNameBean.setName(resource.getResourceUrl());
        ruleBean.setResourceName(resourceNameBean);
        Permit postPermit = resource.getPostPermit();
        if (postPermit != Permit.INDETERMINATE) {
            OpenAMAttributeValuePair postAttributeValuePairBean = new OpenAMAttributeValuePair();
            ruleBean.getAttributeValuePair().add(postAttributeValuePairBean);
            OpenAMAttribute postAttributeBean = new OpenAMAttribute();
            postAttributeBean.setName("POST");
            postAttributeValuePairBean.setAttribute(postAttributeBean);
            String postPermitString = postPermit.getInternalValue();
            postAttributeValuePairBean.getValue().add(postPermitString);
        }
        if ((getPermit = resource.getGetPermit()) != Permit.INDETERMINATE) {
            OpenAMAttributeValuePair getAttributeValuePairBean = new OpenAMAttributeValuePair();
            ruleBean.getAttributeValuePair().add(getAttributeValuePairBean);
            OpenAMAttribute getAttributeBean = new OpenAMAttribute();
            getAttributeBean.setName("GET");
            getAttributeValuePairBean.setAttribute(getAttributeBean);
            String getPermitString = getPermit.getInternalValue();
            getAttributeValuePairBean.getValue().add(getPermitString);
        }
        return ruleBean;
    }

    private OpenAMSubjects createSubjects(List<Subject> subjectList) {
        OpenAMSubjects subjectsBean = new OpenAMSubjects();
        subjectsBean.setName(OpenAMNamingUtil.generateSubjectsName());
        OpenAMSubject subjectBean = this.createSubjectBySubjectList(subjectList);
        if (subjectBean != null) {
            subjectsBean.getSubject().add(subjectBean);
        }
        return subjectsBean;
    }

    private OpenAMSubject createSubjectBySubjectList(List<Subject> subjectList) {
        OpenAMSubject subjectBean = new OpenAMSubject();
        if (subjectList.size() != 0) {
            subjectBean.setName(OpenAMNamingUtil.generateSubjectName());
            subjectBean.setType("AMIdentitySubject");
            subjectBean.setIncludeType("inclusive");
            OpenAMAttributeValuePair attributeValuePairBean = new OpenAMAttributeValuePair();
            subjectBean.getAttributeValuePair().add(attributeValuePairBean);
            OpenAMAttribute attributeBean = new OpenAMAttribute();
            attributeBean.setName("Values");
            attributeValuePairBean.setAttribute(attributeBean);
            for (Subject subject : subjectList) {
                String valueText = subject.getSubjectCode();
                attributeValuePairBean.getValue().add(valueText);
            }
        }
        return subjectBean;
    }
}

