/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.common.api.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.ogis_ri.citk.policytool.common.api.impl.model.OpenAMAttributeValuePair;
import jp.co.ogis_ri.citk.policytool.common.api.impl.model.OpenAMPolicies;
import jp.co.ogis_ri.citk.policytool.common.api.impl.model.OpenAMPolicy;
import jp.co.ogis_ri.citk.policytool.common.api.impl.model.OpenAMRule;
import jp.co.ogis_ri.citk.policytool.common.logging.LogWrapperFactory;
import jp.co.ogis_ri.citk.policytool.common.util.ApplicationContextUtil;
import jp.co.ogis_ri.citk.policytool.common.util.OpenAMNamingUtil;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Permit;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;
import org.apache.commons.logging.Log;

class PoliciesBuilder {
    private Map<String, OpenAMPolicies> openAMpolicies = new HashMap<String, OpenAMPolicies>();

    public void add(String realmName, OpenAMPolicies openAMpolicies) {
        this.openAMpolicies.put(realmName, openAMpolicies);
    }

    public List<Policy> build() {
        ArrayList<Policy> policies = new ArrayList<Policy>();
        for (String realmName : this.openAMpolicies.keySet()) {
            policies.addAll(this.buildPolicies(realmName, this.openAMpolicies.get(realmName)));
        }
        return policies;
    }

    private List<Policy> buildPolicies(String realmName, OpenAMPolicies openAMpolicies) {
        ArrayList<Policy> policies = new ArrayList<Policy>();
        for (OpenAMPolicy openAMPolicy : openAMpolicies.getPolicy()) {
            if (openAMPolicy.isReferralPolicy().booleanValue()) continue;
            Policy policy = this.buildPolicy(realmName, openAMPolicy);
            if (policy.getResources().size() == 0 || policy.getSubjects().size() == 0) {
                Log logger = LogWrapperFactory.getLog(PoliciesBuilder.class);
                logger.warn((Object)ApplicationContextUtil.getResources().getMessage("common.policyBuilder.policyNoResOrNoSubjMsg", new Object[]{policy.toString()}));
                continue;
            }
            policies.add(policy);
        }
        return policies;
    }

    private Policy buildPolicy(String realmName, OpenAMPolicy openAMPolicy) {
        Policy policy = new Policy(realmName, openAMPolicy.getName());
        for (OpenAMRule openAMRule : openAMPolicy.getRule()) {
            String url = openAMRule.getResourceName().getName();
            Permit get = Permit.INDETERMINATE;
            Permit post = Permit.INDETERMINATE;
            for (OpenAMAttributeValuePair attr : openAMRule.getAttributeValuePair()) {
                if (attr.getAttribute().getName().equalsIgnoreCase("GET")) {
                    get = Permit.internalValueOf(attr.getValue().get(0));
                    continue;
                }
                if (!attr.getAttribute().getName().equalsIgnoreCase("POST")) continue;
                post = Permit.internalValueOf(attr.getValue().get(0));
            }
            policy.addResource(url, get, post);
        }
        if (openAMPolicy.getSubjects() != null && openAMPolicy.getSubjects().getSubject().size() != 0) {
            for (String value : openAMPolicy.getSubjects().getSubject().get(0).getAttributeValuePair().get(0).getValue()) {
                Map<String, String> kv = OpenAMNamingUtil.splitValue(value);
                policy.addSubject(kv.get("id"), value);
            }
        }
        return policy;
    }
}

