/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.common.api.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.co.ogis_ri.citk.policytool.common.api.impl.model.OpenAMPolicies;
import jp.co.ogis_ri.citk.policytool.common.api.impl.model.OpenAMPolicy;
import jp.co.ogis_ri.citk.policytool.common.api.impl.model.OpenAMReferral;
import jp.co.ogis_ri.citk.policytool.common.api.impl.model.OpenAMResourceName;
import jp.co.ogis_ri.citk.policytool.common.api.impl.model.OpenAMRule;
import jp.co.ogis_ri.citk.policytool.common.logging.LogWrapperFactory;
import jp.co.ogis_ri.citk.policytool.common.util.ApplicationContextUtil;
import jp.co.ogis_ri.citk.policytool.common.util.OpenAMNamingUtil;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Group;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Realm;
import jp.co.ogis_ri.citk.policytool.domain.realm.model.Referral;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.logging.Log;

class RealmsBuilder {
    private List<String> realms = new ArrayList<String>();
    private Map<String, List<Group>> groups = new TreeMap<String, List<Group>>();
    private Map<String, List<Referral>> refPolicies = new TreeMap<String, List<Referral>>();

    public void addRealms(List<String> realms) {
        this.realms.addAll(realms);
    }

    public void addGroups(String realmName, List<String> groupValues) {
        List<Object> groups = null;
        if (this.groups.containsKey(realmName)) {
            groups = this.groups.get(realmName);
        } else {
            groups = new ArrayList();
            this.groups.put(realmName, groups);
        }
        for (String groupValue : groupValues) {
            String[] v = groupValue.split("\\(");
            groups.add(new Group(v[0].trim(), this.getGroupCode(groupValue)));
        }
    }

    public void addPolicies(OpenAMPolicies policies) {
        List<Object> refPolicies = null;
        for (OpenAMPolicy policy : policies.getPolicy()) {
            Log logger;
            if (!policy.isReferralPolicy().booleanValue()) continue;
            if (policy.getRule().size() == 0) {
                logger = LogWrapperFactory.getLog(RealmsBuilder.class);
                logger.warn((Object)ApplicationContextUtil.getResources().getMessage("common.realmBuilder.noRuleMsg", new Object[]{ReflectionToStringBuilder.toString((Object)policy, (ToStringStyle)ToStringStyle.DEFAULT_STYLE)}));
                continue;
            }
            if (policy.getReferrals() == null) {
                logger = LogWrapperFactory.getLog(RealmsBuilder.class);
                logger.warn((Object)ApplicationContextUtil.getResources().getMessage("common.realmBuilder.noReferralMsg", new Object[]{ReflectionToStringBuilder.toString((Object)policy, (ToStringStyle)ToStringStyle.DEFAULT_STYLE)}));
                continue;
            }
            for (OpenAMReferral referral : policy.getReferrals().getReferral()) {
                if (!referral.getType().equalsIgnoreCase("SubOrgReferral")) continue;
                String value = referral.getAttributeValuePair().get(0).getValue().get(0);
                Map<String, String> v = OpenAMNamingUtil.splitValue(value);
                String realmName = v.get("o");
                if (realmName == null) {
                    Log logger2 = LogWrapperFactory.getLog(RealmsBuilder.class);
                    logger2.warn((Object)ApplicationContextUtil.getResources().getMessage("common.realmBuilder.referralNoRealmnameMsg", new Object[]{ReflectionToStringBuilder.toString((Object)referral, (ToStringStyle)ToStringStyle.DEFAULT_STYLE)}));
                    continue;
                }
                if (this.refPolicies.containsKey(realmName = realmName.trim())) {
                    refPolicies = this.refPolicies.get(realmName);
                } else {
                    refPolicies = new ArrayList();
                    this.refPolicies.put(realmName, refPolicies);
                }
                for (OpenAMRule rule : policy.getRule()) {
                    OpenAMResourceName resName = rule.getResourceName();
                    if (resName == null || resName.getName() == null || resName.getName().length() == 0) {
                        Log logger3 = LogWrapperFactory.getLog(RealmsBuilder.class);
                        logger3.warn((Object)ApplicationContextUtil.getResources().getMessage("common.realmBuilder.ruleNoResourceNameMsg", new Object[]{ReflectionToStringBuilder.toString((Object)rule, (ToStringStyle)ToStringStyle.DEFAULT_STYLE)}));
                        continue;
                    }
                    refPolicies.add(new Referral(rule.getResourceName().getName()));
                }
            }
        }
    }

    public List<Realm> build() {
        ArrayList<Realm> realms = new ArrayList<Realm>();
        for (String realmName : this.realms) {
            Realm realm = new Realm(realmName);
            realms.add(realm);
            if (this.groups.containsKey(realmName)) {
                realm.getGroups().addAll((Collection<Group>)this.groups.get(realmName));
            }
            if (this.refPolicies.containsKey(realmName)) {
                realm.getReferrals().addAll((Collection<Referral>)this.refPolicies.get(realmName));
            }
            for (Group group : realm.getGroups()) {
                group.setRealm(realm);
            }
            for (Referral referral : realm.getReferrals()) {
                referral.setRealm(realm);
            }
        }
        return realms;
    }

    private String getGroupCode(String groupValue) {
        String text = "";
        Matcher m = Pattern.compile("\\(.*?\\)").matcher(groupValue);
        if (m.find()) {
            text = groupValue.substring(m.start() + 1, m.end() - 1);
        }
        return text;
    }
}

