/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.common.api.impl.ssoadm;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.co.ogis_ri.citk.policytool.common.api.impl.ssoadm.SsoadmResult;

abstract class AbstractSsoadmResultParser {
    private final String HTML_PRE_PREFIX = "<pre>";
    private final String HTML_PRE_SUFFIX = "</pre>";
    private final String EXITCODE_PREFIX = "<!-- CLI Exit Code:";
    private final String EXITCODE_SUFFIX = "-->";

    AbstractSsoadmResultParser() {
    }

    public SsoadmResult parse(String s) {
        String preString = this.parsePre(s);
        return new SsoadmResult(this.parseData(preString), this.parseExitCode(preString));
    }

    protected abstract List<String> parseData(String var1);

    protected String cutText(String prefix, String suffix, String s, boolean include) {
        String text = null;
        Matcher m = Pattern.compile(prefix + ".*" + suffix, 32).matcher(s);
        if (m.find()) {
            text = include ? s.substring(m.start(), m.end()) : s.substring(m.start() + prefix.length(), m.end() - suffix.length());
        }
        return text != null ? text : "";
    }

    private String parsePre(String s) {
        String text = this.cutText("<pre>", "</pre>", s, false);
        return text;
    }

    private int parseExitCode(String s) {
        String text = this.cutText("<!-- CLI Exit Code:", "-->", s, false);
        return Integer.valueOf(text.trim());
    }
}

