/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.common.api.impl.ssoadm;

import jp.co.ogis_ri.citk.policytool.common.api.impl.ssoadm.GroupSsoadmResultParser;
import jp.co.ogis_ri.citk.policytool.common.api.impl.ssoadm.PoliciesSsoadmResultParser;
import jp.co.ogis_ri.citk.policytool.common.api.impl.ssoadm.RealmSsoadmResultParser;
import jp.co.ogis_ri.citk.policytool.common.api.impl.ssoadm.SsoadmResult;
import jp.co.ogis_ri.citk.policytool.common.exception.ApplicationSettingException;
import jp.co.ogis_ri.citk.policytool.common.http.HttpClientWrapper;
import jp.co.ogis_ri.citk.policytool.common.http.HttpResponseWrapper;
import jp.co.ogis_ri.citk.policytool.common.util.StringUtil;
import org.apache.http.Header;

public class SsoadmClient {
    private static final String HEADER_LOCATION = "Location";
    private static final String USERID_PARAM_NAME = "IDToken1";
    private static final String PASSWORD_PARAM_NAME = "IDToken2";
    private static final String LIST_REALMS_PARAM = "cmd=list-realms&submit=";
    private static final String LIST_IDENTITIES_PARAM = "cmd=list-identities&submit=";
    private static final String LIST_POLICIES_PARAM = "cmd=list-policies&submit=";
    private static final String CREATE_POLICIES_PARAM = "cmd=create-policies&submit=";
    private static final String DELETE_POLICIES_PARAM = "cmd=delete-policies&submit=";
    private static final String REALM_PARAM_NAME = "realm";
    private static final String FILTER_PARAM_NAME = "filter";
    private static final String RECURSIVE_PARAM_NAME = "recursive";
    private static final String IDTYPE_PARAM_NAME = "idtype";
    private static final String POLICYNAMES_PARAM_NAME = "policynames";
    private static final String XMLFILE_PARAM_NAME = "xmlfile";
    private static final String GROUP_IDTYPE_NAME = "group";
    private HttpClientWrapper httpClient = null;
    private String urlString = null;
    private String userId = null;
    private String password = null;
    private String encoding = "UTF-8";

    public HttpClientWrapper getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClientWrapper httpClient) {
        this.httpClient = httpClient;
    }

    public String getUrlString() {
        return this.urlString;
    }

    public void setUrlString(String urlString) {
        this.urlString = urlString;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public SsoadmClient() {
    }

    public SsoadmClient(HttpClientWrapper httpClient, String urlString, String userId, String password) {
        this.httpClient = httpClient;
        this.urlString = urlString;
        this.userId = userId;
        this.password = password;
    }

    public SsoadmResult getRealms(String realmName, String filter, boolean recursive) {
        HttpResponseWrapper httpResponse;
        this.login();
        this.httpClient.addQueryParam(REALM_PARAM_NAME, realmName);
        this.httpClient.addQueryParam(FILTER_PARAM_NAME, filter);
        if (recursive) {
            this.httpClient.addQueryParam(RECURSIVE_PARAM_NAME, Boolean.toString(recursive));
        }
        if ((httpResponse = this.httpClient.post(this.urlString + "?" + LIST_REALMS_PARAM)).getHttpStatusCode() != 200) {
            throw new ApplicationSettingException("E-0002", new Object[0]);
        }
        String content = StringUtil.encoding(httpResponse.getContent(), this.encoding);
        RealmSsoadmResultParser parser = new RealmSsoadmResultParser();
        SsoadmResult result = parser.parse(content);
        return result;
    }

    public SsoadmResult getGroup(String realmName, String filter) {
        this.login();
        this.httpClient.addQueryParam(REALM_PARAM_NAME, realmName);
        this.httpClient.addQueryParam(FILTER_PARAM_NAME, filter);
        this.httpClient.addQueryParam(IDTYPE_PARAM_NAME, GROUP_IDTYPE_NAME);
        HttpResponseWrapper httpResponse = this.httpClient.post(this.urlString + "?" + LIST_IDENTITIES_PARAM);
        if (httpResponse.getHttpStatusCode() != 200) {
            throw new ApplicationSettingException("E-0002", new Object[0]);
        }
        String content = StringUtil.encoding(httpResponse.getContent(), this.encoding);
        GroupSsoadmResultParser parser = new GroupSsoadmResultParser();
        SsoadmResult result = parser.parse(content);
        return result;
    }

    public SsoadmResult getPolicies(String realmName, String policyNames) {
        this.login();
        this.httpClient.addQueryParam(REALM_PARAM_NAME, realmName);
        this.httpClient.addQueryParam(POLICYNAMES_PARAM_NAME, policyNames);
        HttpResponseWrapper httpResponse = this.httpClient.post(this.urlString + "?" + LIST_POLICIES_PARAM);
        if (httpResponse.getHttpStatusCode() != 200) {
            throw new ApplicationSettingException("E-0002", new Object[0]);
        }
        String content = StringUtil.encoding(httpResponse.getContent(), this.encoding);
        PoliciesSsoadmResultParser parser = new PoliciesSsoadmResultParser();
        SsoadmResult result = parser.parse(content);
        return result;
    }

    public SsoadmResult createPolicies(String realmName, String xml) {
        this.login();
        this.httpClient.addQueryParam(REALM_PARAM_NAME, realmName);
        this.httpClient.addQueryParam(XMLFILE_PARAM_NAME, xml);
        HttpResponseWrapper httpResponse = this.httpClient.post(this.urlString + "?" + CREATE_POLICIES_PARAM);
        if (httpResponse.getHttpStatusCode() != 200) {
            throw new ApplicationSettingException("E-0002", new Object[0]);
        }
        String content = StringUtil.encoding(httpResponse.getContent(), this.encoding);
        PoliciesSsoadmResultParser parser = new PoliciesSsoadmResultParser();
        SsoadmResult result = parser.parse(content);
        return result;
    }

    public SsoadmResult deletePolicy(String realmName, String policyName) {
        this.login();
        this.httpClient.addQueryParam(REALM_PARAM_NAME, realmName);
        this.httpClient.addQueryParam(POLICYNAMES_PARAM_NAME, policyName);
        HttpResponseWrapper httpResponse = this.httpClient.post(this.urlString + "?" + DELETE_POLICIES_PARAM);
        if (httpResponse.getHttpStatusCode() != 200) {
            throw new ApplicationSettingException("E-0002", new Object[0]);
        }
        String content = StringUtil.encoding(httpResponse.getContent(), this.encoding);
        PoliciesSsoadmResultParser parser = new PoliciesSsoadmResultParser();
        SsoadmResult result = parser.parse(content);
        return result;
    }

    private HttpResponseWrapper login() {
        HttpResponseWrapper httpResponse = this.httpClient.post(this.urlString);
        if (httpResponse.getHttpStatusCode() != 200) {
            Header[] loginUrl = httpResponse.getHttpResponse().getHeaders(HEADER_LOCATION);
            if (loginUrl.length == 0) {
                throw new ApplicationSettingException("E-0002", new Object[0]);
            }
            this.httpClient.addQueryParam(USERID_PARAM_NAME, this.userId);
            this.httpClient.addQueryParam(PASSWORD_PARAM_NAME, this.password);
            httpResponse = this.httpClient.post(loginUrl[0].getValue());
        }
        return httpResponse;
    }
}

