/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.common.excel.impl;

import java.util.ArrayList;
import java.util.List;
import jp.co.ogis_ri.citk.policytool.common.excel.impl.model.ExcelPolicy;
import jp.co.ogis_ri.citk.policytool.common.exception.SystemException;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Permit;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Resource;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Subject;

class ExcelPolicyFactory {
    ExcelPolicyFactory() {
    }

    public static ExcelPolicy create(List<String> values) {
        if (values.size() < 6) {
            throw new SystemException("size error: " + String.valueOf(values.size()));
        }
        ExcelPolicy excelPolicy = new ExcelPolicy();
        excelPolicy.setRealmName(values.get(0));
        excelPolicy.setPolicyName(values.get(1));
        excelPolicy.setResourceUrl(values.get(2));
        excelPolicy.setGetPermitValue(values.get(3));
        excelPolicy.setPostPermitValue(values.get(4));
        excelPolicy.setSubject(values.get(5));
        return excelPolicy;
    }

    public static List<ExcelPolicy> create(Policy policy) {
        ExcelPolicy excelPolicy;
        ArrayList<ExcelPolicy> list = new ArrayList<ExcelPolicy>();
        for (Resource resource : policy.getResources()) {
            excelPolicy = new ExcelPolicy();
            excelPolicy.setRealmName(policy.getRealmName());
            excelPolicy.setPolicyName(policy.getPolicyName());
            excelPolicy.setResourceUrl(resource.getResourceUrl());
            excelPolicy.setGetPermitValue(ExcelPolicyFactory.getPermitValue(resource.getGetPermit()));
            excelPolicy.setPostPermitValue(ExcelPolicyFactory.getPermitValue(resource.getPostPermit()));
            list.add(excelPolicy);
        }
        for (Subject subject : policy.getSubjects()) {
            excelPolicy = new ExcelPolicy();
            excelPolicy.setRealmName(policy.getRealmName());
            excelPolicy.setPolicyName(policy.getPolicyName());
            excelPolicy.setSubject(subject.getSubjectCode());
            list.add(excelPolicy);
        }
        return list;
    }

    private static String getPermitValue(Permit permit) {
        if (permit == Permit.INDETERMINATE) {
            return "INDETERMINATE";
        }
        return permit.getInternalValue().toUpperCase();
    }
}

