/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.common.excel.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jp.co.ogis_ri.citk.policytool.common.excel.ExcelPolicyReader;
import jp.co.ogis_ri.citk.policytool.common.excel.impl.ExcelPolicyFactory;
import jp.co.ogis_ri.citk.policytool.common.excel.impl.PolicyBuilder;
import jp.co.ogis_ri.citk.policytool.common.excel.impl.WorkbookWrapper;
import jp.co.ogis_ri.citk.policytool.common.excel.impl.model.ExcelPolicy;
import jp.co.ogis_ri.citk.policytool.common.exception.ExcelPolicyReadException;
import jp.co.ogis_ri.citk.policytool.common.logging.LogWrapperFactory;
import jp.co.ogis_ri.citk.policytool.common.util.ExceptionUtil;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;
import org.apache.commons.logging.Log;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.OfficeXmlFileException;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.stereotype.Component;

@Component
public class ExcelPolicyReaderImpl
implements ExcelPolicyReader {
    private Log logger = LogWrapperFactory.getLog(ExcelPolicyReaderImpl.class);

    @Override
    public List<Policy> read(String fileName) throws ExcelPolicyReadException {
        if (fileName.isEmpty()) {
            throw new ExcelPolicyReadException(fileName, "E-0006", new Object[0]);
        }
        PolicyBuilder builder = new PolicyBuilder();
        HSSFWorkbook workbook = null;
        try {
            workbook = WorkbookWrapper.createHSSFWorkbook(fileName);
        }
        catch (OfficeXmlFileException e) {
            this.logger.debug((Object)e.getMessage(), (Throwable)e);
            throw new ExcelPolicyReadException(fileName, "E-0007", fileName);
        }
        catch (FileNotFoundException e) {
            this.logger.debug((Object)e.getMessage(), (Throwable)e);
            throw new ExcelPolicyReadException(fileName, "E-0008", fileName);
        }
        catch (IOException e) {
            this.logger.debug((Object)e.getMessage(), (Throwable)e);
            throw ExceptionUtil.convertRuntimeException(e);
        }
        WorkbookWrapper workbookWrapper = new WorkbookWrapper((Workbook)workbook);
        workbookWrapper.selectSheet(0, 1, 0);
        while (workbookWrapper.existRow()) {
            List<?> values = workbookWrapper.readRow(6);
            ArrayList<String> stringValues = new ArrayList<String>(6);
            for (Object value : values) {
                try {
                    stringValues.add((String)value);
                }
                catch (ClassCastException e) {
                    this.logger.debug((Object)e.getMessage(), (Throwable)e);
                    throw new ExcelPolicyReadException(fileName, (Throwable)e, "E-0009", new Object[0]);
                }
            }
            ExcelPolicy excelPolicy = ExcelPolicyFactory.create(stringValues);
            builder.add(excelPolicy);
        }
        return builder.build();
    }
}

