/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.common.excel.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import jp.co.ogis_ri.citk.policytool.common.excel.ExcelPolicyWriter;
import jp.co.ogis_ri.citk.policytool.common.excel.impl.ExcelPolicyBuilder;
import jp.co.ogis_ri.citk.policytool.common.excel.impl.WorkbookWrapper;
import jp.co.ogis_ri.citk.policytool.common.excel.impl.model.ExcelPolicy;
import jp.co.ogis_ri.citk.policytool.common.logging.LogWrapperFactory;
import jp.co.ogis_ri.citk.policytool.common.util.ExceptionUtil;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;
import org.apache.commons.logging.Log;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.stereotype.Component;

@Component
public class ExcelPolicyWriterImpl
implements ExcelPolicyWriter {
    private static final Log logger = LogWrapperFactory.getLog(ExcelPolicyWriterImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String fileName, List<Policy> policies) {
        InputStream template = null;
        try {
            template = ExcelPolicyWriterImpl.class.getResourceAsStream("/policy.xlt");
            ExcelPolicyBuilder builder = new ExcelPolicyBuilder();
            HSSFWorkbook workbook = null;
            try {
                workbook = new HSSFWorkbook(template);
            }
            catch (IOException e) {
                logger.debug((Object)(fileName + " : " + e.getMessage()), (Throwable)e);
                throw ExceptionUtil.convertRuntimeException(e);
            }
            WorkbookWrapper workbookWrapper = new WorkbookWrapper((Workbook)workbook);
            workbookWrapper.selectSheet(0, 1, 0);
            builder.addAll(policies);
            List<ExcelPolicy> excelPolicies = builder.build();
            for (ExcelPolicy excelPolicy : excelPolicies) {
                workbookWrapper.writeRow(excelPolicy.toValues());
            }
            workbookWrapper.saveAs(fileName, true);
        }
        finally {
            if (template != null) {
                try {
                    template.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

