/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.common.excel.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jp.co.ogis_ri.citk.policytool.common.excel.impl.model.ExcelPolicy;
import jp.co.ogis_ri.citk.policytool.common.util.OpenAMNamingUtil;
import jp.co.ogis_ri.citk.policytool.domain.policy.model.Policy;

class PolicyBuilder {
    private List<ExcelPolicy> excelPolicies = new ArrayList<ExcelPolicy>();

    PolicyBuilder() {
    }

    public void add(ExcelPolicy excelPolicy) {
        this.excelPolicies.add(excelPolicy);
    }

    public List<Policy> build() {
        TreeMap<String, Policy> policies = new TreeMap<String, Policy>();
        for (ExcelPolicy excelPolicy : this.excelPolicies) {
            Policy policy;
            String key = this.getKey(excelPolicy);
            if (policies.containsKey(key)) {
                policy = (Policy)policies.get(key);
            } else {
                policy = new Policy();
                policies.put(key, policy);
            }
            policy.setRealmName(excelPolicy.getRealmName());
            policy.setPolicyName(excelPolicy.getPolicyName());
            if (excelPolicy.getResourceUrl() != null && excelPolicy.getGetPermitValue() != null && excelPolicy.getPostPermitValue() != null) {
                policy.addResource(excelPolicy.getResourceUrl(), excelPolicy.getGetPermitValue(), excelPolicy.getPostPermitValue());
            }
            if (excelPolicy.getSubject() == null) continue;
            Map<String, String> kv = OpenAMNamingUtil.splitValue(excelPolicy.getSubject());
            policy.addSubject(kv.get("id"), excelPolicy.getSubject());
        }
        return new ArrayList<Policy>(policies.values());
    }

    private String getKey(ExcelPolicy excelPolicy) {
        return excelPolicy.getRealmName() + "_" + excelPolicy.getPolicyName();
    }
}

