/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.common.excel.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import jp.co.ogis_ri.citk.policytool.common.exception.SystemException;
import jp.co.ogis_ri.citk.policytool.common.logging.LogWrapperFactory;
import jp.co.ogis_ri.citk.policytool.common.util.ExceptionUtil;
import org.apache.commons.logging.Log;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

class WorkbookWrapper {
    private static final Log logger = LogWrapperFactory.getLog(WorkbookWrapper.class);
    private Workbook workbook = null;
    private Sheet currentSheet = null;
    private int currentRow = 0;
    private int currentColumn = 0;
    private int offsetRow = 0;
    private int offsetColumn = 0;

    public static HSSFWorkbook createHSSFWorkbook(String fileName) throws IOException {
        FileInputStream is = new FileInputStream(fileName);
        HSSFWorkbook workbook = new HSSFWorkbook((InputStream)is);
        return workbook;
    }

    public WorkbookWrapper() {
        this((Workbook)new HSSFWorkbook());
    }

    public WorkbookWrapper(Workbook workbook) {
        this.workbook = workbook;
        this.selectSheet(0, 0, 0);
    }

    public void saveAs(String fileName, boolean overWrite) {
        File file = new File(fileName);
        if (file.exists() && !overWrite) {
            return;
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            this.workbook.write((OutputStream)os);
        }
        catch (IOException e) {
            logger.debug((Object)(fileName + " : " + e.getMessage()), (Throwable)e);
            throw ExceptionUtil.convertRuntimeException(e);
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void selectSheet(int index, int offsetRow, int offsetColumn) {
        this.currentSheet = this.workbook.getSheetAt(index);
        this.offsetRow = offsetRow;
        this.offsetColumn = offsetColumn;
        this.resetCurrent();
    }

    public void selectSheet(String sheetName, int offsetRow, int offsetColumn) {
        this.selectSheet(this.workbook.getSheetIndex(sheetName), offsetRow, offsetColumn);
    }

    public boolean existRow() {
        Row currentRow = this.currentSheet.getRow(this.getCurrentRow());
        if (currentRow == null) {
            return false;
        }
        Cell cell = currentRow.getCell(0);
        if (cell == null) {
            return false;
        }
        Object cellValue = this.getCellValue(cell);
        return cellValue != null && !cellValue.equals("");
    }

    public List<?> readRow() {
        Cell _cell;
        Object value;
        ArrayList<Object> values = new ArrayList<Object>();
        Row _row = this.getRow(this.currentSheet, this.getCurrentRow());
        ++this.currentRow;
        this.currentColumn = 0;
        while ((value = this.getCellValue(_cell = this.getCell(_row, this.getCurrentColumn()))) != null) {
            values.add(value);
            ++this.currentColumn;
        }
        return values;
    }

    public List<?> readRow(int size) {
        ArrayList<Object> values = new ArrayList<Object>();
        Row _row = this.getRow(this.currentSheet, this.getCurrentRow());
        ++this.currentRow;
        this.currentColumn = 0;
        while (size-- > 0) {
            Cell _cell = this.getCell(_row, this.getCurrentColumn());
            Object value = this.getCellValue(_cell);
            values.add(value);
            ++this.currentColumn;
        }
        return values;
    }

    public void writeRow(List<?> values) {
        Row _row = this.getRow(this.currentSheet, this.getCurrentRow());
        ++this.currentRow;
        this.currentColumn = 0;
        for (Object value : values) {
            Cell _cell = this.getCell(_row, this.getCurrentColumn());
            this.setCellValue(_cell, value);
            ++this.currentColumn;
        }
    }

    public Object getCellValue(int index, int row, int column) {
        Sheet _sheet = this.workbook.getSheetAt(index);
        Row _row = this.getRow(_sheet, row);
        Cell _cell = this.getCell(_row, column);
        return this.getCellValue(_cell);
    }

    public Object getCellValue(String sheetName, int row, int column) {
        return this.getCellValue(this.workbook.getSheetIndex(sheetName), row, column);
    }

    public void setCellValue(int index, int row, int column, Object value) {
        Sheet _sheet = this.workbook.getSheetAt(index);
        Row _row = this.getRow(_sheet, row);
        Cell _cell = this.getCell(_row, column);
        this.setCellValue(_cell, value);
    }

    public void setCellValue(String sheetName, int row, int column, Object value) {
        this.setCellValue(this.workbook.getSheetIndex(sheetName), row, column, value);
    }

    public void resetCurrent() {
        this.currentRow = 0;
        this.currentColumn = 0;
    }

    private int getCurrentRow() {
        return this.currentRow + this.offsetRow;
    }

    private int getCurrentColumn() {
        return this.currentColumn + this.offsetColumn;
    }

    private Row getRow(Sheet sheet, int row) {
        return sheet.getRow(row) != null ? sheet.getRow(row) : sheet.createRow(row);
    }

    private Cell getCell(Row row, int column) {
        return row.getCell(column) != null ? row.getCell(column) : row.createCell(column);
    }

    private Object getCellValue(Cell cell) {
        Object value = null;
        switch (cell.getCellType()) {
            case 3: {
                value = null;
                break;
            }
            case 4: {
                value = cell.getBooleanCellValue();
                break;
            }
            case 0: {
                value = cell.getNumericCellValue();
                break;
            }
            case 1: {
                value = cell.getStringCellValue();
                break;
            }
            default: {
                throw new SystemException("not supported cell type: " + cell);
            }
        }
        return value;
    }

    private void setCellValue(Cell cell, Object value) {
        if (value instanceof String) {
            cell.setCellType(1);
            cell.setCellValue((String)String.class.cast(value));
        } else if (value instanceof Number) {
            cell.setCellType(0);
            cell.setCellValue(((Double)Double.class.cast(value)).doubleValue());
        } else if (value instanceof Boolean) {
            cell.setCellType(4);
            cell.setCellValue(((Boolean)Boolean.class.cast(value)).booleanValue());
        } else if (value != null) {
            throw new SystemException("not supported value type: " + value);
        }
    }
}

