/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.common.http;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import jp.co.ogis_ri.citk.policytool.common.http.HttpResponseWrapper;
import jp.co.ogis_ri.citk.policytool.common.logging.LogWrapperFactory;
import jp.co.ogis_ri.citk.policytool.common.util.ExceptionUtil;
import org.apache.commons.logging.Log;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;

public class HttpClientWrapper {
    private final Log logger = LogWrapperFactory.getLog(HttpClientWrapper.class);
    private DefaultHttpClient httpClient = null;
    private List<NameValuePair> queryParams = new ArrayList<NameValuePair>();
    private String encoding = "UTF-8";
    private String cookiePolicy = "rfc2109";

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getCookiePolicy() {
        return this.cookiePolicy;
    }

    public void setCookiePolicy(String cookiePolicy) {
        this.cookiePolicy = cookiePolicy;
    }

    public HttpClientWrapper() {
        this.httpClient = new DefaultHttpClient();
    }

    public HttpClientWrapper(DefaultHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public void addQueryParam(String name, String value) {
        this.queryParams.add((NameValuePair)new BasicNameValuePair(name, value));
    }

    public void clearQueryParam() {
        this.queryParams.clear();
    }

    public void addCookie(Cookie cookie) {
        this.httpClient.getCookieStore().addCookie(cookie);
    }

    public void clearCookieStore() {
        this.httpClient.getCookieStore().clear();
    }

    public HttpResponseWrapper get(String urlString) {
        URI uri = this.createURI(urlString);
        HttpGet request = new HttpGet(uri);
        return this.execute((HttpUriRequest)request);
    }

    public HttpResponseWrapper get(URL url) {
        URI uri = this.createURI(url);
        HttpGet request = new HttpGet(uri);
        return this.execute((HttpUriRequest)request);
    }

    public HttpResponseWrapper post(String urlString) {
        HttpPost request = new HttpPost(urlString);
        try {
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(this.queryParams, this.encoding));
        }
        catch (UnsupportedEncodingException e) {
            this.logger.debug((Object)e.getMessage());
            throw ExceptionUtil.convertRuntimeException(e);
        }
        return this.execute((HttpUriRequest)request);
    }

    public HttpResponseWrapper post(URI uri) {
        HttpPost request = new HttpPost(uri);
        try {
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(this.queryParams, this.encoding));
        }
        catch (UnsupportedEncodingException e) {
            this.logger.debug((Object)e.getMessage());
            throw ExceptionUtil.convertRuntimeException(e);
        }
        return this.execute((HttpUriRequest)request);
    }

    public void shutdown() {
        this.httpClient.getConnectionManager().shutdown();
    }

    private URI createURI(String urlString) {
        URI uri = null;
        try {
            uri = this.createURI(new URL(urlString));
        }
        catch (MalformedURLException e) {
            this.logger.debug((Object)e.getMessage());
            throw ExceptionUtil.convertRuntimeException(e);
        }
        return uri;
    }

    private URI createURI(URL url) {
        URI uri = null;
        try {
            uri = URIUtils.createURI((String)url.getProtocol(), (String)url.getHost(), (int)url.getPort(), (String)url.getPath(), (String)(!this.queryParams.isEmpty() ? URLEncodedUtils.format(this.queryParams, (String)this.encoding) : (url.getQuery() != null ? url.getQuery() : "")), null);
        }
        catch (URISyntaxException e) {
            this.logger.debug((Object)e.getMessage());
            throw ExceptionUtil.convertRuntimeException(e);
        }
        return uri;
    }

    private HttpResponseWrapper execute(HttpUriRequest request) {
        HttpResponseWrapper response = null;
        try {
            this.logger.debug((Object)("Request Line:" + request.getRequestLine().toString()));
            request.getParams().setParameter("http.protocol.cookie-policy", (Object)this.cookiePolicy);
            response = new HttpResponseWrapper(this.httpClient.execute(request));
            this.logger.debug((Object)("HTTP Status Code:" + String.valueOf(response.getHttpStatusCode())));
            if (this.logger.isDebugEnabled()) {
                for (Header h : response.getHttpResponse().getAllHeaders()) {
                    this.logger.debug((Object)("HTTP HEADER - " + h.getName() + "=" + h.getValue()));
                }
                List cookies = this.httpClient.getCookieStore().getCookies();
                if (cookies.isEmpty()) {
                    this.logger.debug((Object)"COOKIES - None");
                } else {
                    for (int i = 0; i < cookies.size(); ++i) {
                        this.logger.debug((Object)("COOKIES - " + ((Cookie)cookies.get(i)).toString()));
                    }
                }
            }
        }
        catch (ClientProtocolException e) {
            this.logger.debug((Object)e.getMessage());
            throw ExceptionUtil.convertRuntimeException(e);
        }
        catch (IOException e) {
            this.logger.debug((Object)e.getMessage());
            throw ExceptionUtil.convertRuntimeException(e);
        }
        finally {
            this.clearQueryParam();
        }
        return response;
    }
}

