/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.common.http;

import java.io.IOException;
import jp.co.ogis_ri.citk.policytool.common.util.StreamUtil;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;

public class HttpResponseWrapper {
    private HttpResponse httpResponse = null;
    private byte[] content = null;

    protected HttpResponseWrapper(HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
        try {
            this.content = StreamUtil.toByteArray(httpResponse.getEntity().getContent());
            EntityUtils.consume((HttpEntity)httpResponse.getEntity());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public byte[] getContent() {
        return this.content;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public String getProtocolVersion() {
        return this.httpResponse.getProtocolVersion().toString();
    }

    public int getHttpStatusCode() {
        return this.httpResponse.getStatusLine().getStatusCode();
    }

    public String getReasonPhrase() {
        return this.httpResponse.getStatusLine().getReasonPhrase();
    }

    public Header[] getHeaders(String name) {
        return this.httpResponse.getHeaders(name);
    }
}

