/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.common.logging;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LogWrapperFactory {
    private static final String OPERAION_LOG = "operation";

    private LogWrapperFactory() {
    }

    public static Log getLog(Class<?> clazz) {
        return (Log)Proxy.newProxyInstance(Log.class.getClassLoader(), new Class[]{Log.class}, (InvocationHandler)new LogWrapper(LogFactory.getLog(clazz)));
    }

    public static Log getLog(String name) {
        return (Log)Proxy.newProxyInstance(Log.class.getClassLoader(), new Class[]{Log.class}, (InvocationHandler)new LogWrapper(LogFactory.getLog((String)name)));
    }

    public static Log getOperationLog() {
        return (Log)Proxy.newProxyInstance(Log.class.getClassLoader(), new Class[]{Log.class}, (InvocationHandler)new LogWrapper(LogFactory.getLog((String)OPERAION_LOG)));
    }

    private static class LogWrapper
    implements InvocationHandler {
        private Log logger = null;

        public LogWrapper(Log logger) {
            this.logger = logger;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result = null;
            Method m = this.logger.getClass().getDeclaredMethod(method.getName(), method.getParameterTypes());
            if (m.getName().equals("fatal")) {
                if (this.logger.isFatalEnabled()) {
                    result = m.invoke((Object)this.logger, args);
                }
            } else if (m.getName().equals("error")) {
                if (this.logger.isErrorEnabled()) {
                    result = m.invoke((Object)this.logger, args);
                }
            } else if (m.getName().equals("warn")) {
                if (this.logger.isWarnEnabled()) {
                    result = m.invoke((Object)this.logger, args);
                }
            } else if (m.getName().equals("info")) {
                if (this.logger.isInfoEnabled()) {
                    result = m.invoke((Object)this.logger, args);
                }
            } else if (m.getName().equals("debug")) {
                if (this.logger.isDebugEnabled()) {
                    result = m.invoke((Object)this.logger, args);
                }
            } else if (m.getName().equals("trace")) {
                if (this.logger.isTraceEnabled()) {
                    result = m.invoke((Object)this.logger, args);
                }
            } else {
                result = m.invoke((Object)this.logger, args);
            }
            return result;
        }
    }
}

