/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.common.repository;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import jp.co.ogis_ri.citk.policytool.common.model.AbstractModel;
import jp.co.ogis_ri.citk.policytool.common.repository.GenericRepository;

public abstract class JpaGenericRepository<E extends AbstractModel<K>, K extends Serializable>
implements GenericRepository<E, K> {
    @PersistenceContext
    protected EntityManager em;
    private Class<E> entityClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];

    @Override
    public List<E> findAll() {
        return this.em.createQuery("SELECT e FROM " + this.entityClass.getSimpleName() + " e").getResultList();
    }

    @Override
    public E findById(K id) {
        return (E)((AbstractModel)this.em.find(this.entityClass, id));
    }

    @Override
    public void persist(E entity) {
        this.em.persist(entity);
    }

    @Override
    public E merge(E entity) {
        return (E)((AbstractModel)this.em.merge(entity));
    }

    @Override
    public void remove(E entity) {
        this.em.remove(this.em.merge(entity));
    }

    @Override
    public void removeAll() {
        List<E> realms = this.findAll();
        for (AbstractModel realm : realms) {
            this.em.remove((Object)realm);
        }
    }

    @Override
    public void reflesh(E entity) {
        this.em.refresh(entity);
    }
}

