/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.common.util;

import java.util.Properties;
import jp.co.ogis_ri.citk.policytool.common.exception.SystemException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.MessageSourceAccessor;

public class ApplicationContextUtil {
    private static String FILE_APPLICATION_CONTEXT = "applicationContext.xml";
    private static String ID_PROPERTIES = "policytoolProperty";
    private static String ID_RESOURCES = "messageSourceAccessor";
    private static ApplicationContext context = null;

    private ApplicationContextUtil() {
    }

    public static ApplicationContext getContext() {
        if (context == null) {
            context = new ClassPathXmlApplicationContext(new String[]{FILE_APPLICATION_CONTEXT});
        }
        return context;
    }

    public static Object getBean(String id) {
        if (!ApplicationContextUtil.getContext().containsBean(id)) {
            throw new SystemException("Not found spring bean id: " + id);
        }
        return ApplicationContextUtil.getContext().getBean(id);
    }

    public static <T> T getBean(Class<T> clazz) {
        return (T)ApplicationContextUtil.getContext().getBean(clazz);
    }

    public static Properties getProperties() {
        return (Properties)ApplicationContextUtil.getBean(ID_PROPERTIES);
    }

    public static MessageSourceAccessor getResources() {
        return (MessageSourceAccessor)ApplicationContextUtil.getBean(ID_RESOURCES);
    }
}

