/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.common.util;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import javax.validation.ConstraintViolationException;
import jp.co.ogis_ri.citk.policytool.common.exception.ApplicationException;
import jp.co.ogis_ri.citk.policytool.common.exception.ApplicationSettingException;
import jp.co.ogis_ri.citk.policytool.common.exception.SystemException;
import org.apache.http.conn.HttpHostConnectException;

public class ExceptionUtil {
    private ExceptionUtil() {
    }

    public static RuntimeException convertRuntimeException(Throwable t) {
        if (t instanceof HttpHostConnectException) {
            return new ApplicationSettingException(t, "E-0001", ((HttpHostConnectException)t).getHost());
        }
        if (t instanceof UnsupportedEncodingException) {
            return new ApplicationSettingException(t, "E-0003", t.getMessage());
        }
        if (t instanceof ConstraintViolationException) {
            return new ApplicationException(t, "E-0005", t.getMessage());
        }
        if (t instanceof Error) {
            throw (Error)Error.class.cast(t);
        }
        if (t instanceof RuntimeException) {
            return (RuntimeException)RuntimeException.class.cast(t);
        }
        if (t instanceof InvocationTargetException) {
            return ExceptionUtil.convertRuntimeException(t.getCause());
        }
        return new SystemException(t);
    }
}

