/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.Manifest;
import jp.co.ogis_ri.citk.policytool.common.logging.LogWrapperFactory;
import jp.co.ogis_ri.citk.policytool.common.util.ExceptionUtil;
import org.apache.commons.logging.Log;

public class ManifestUtl {
    private static final Log logger = LogWrapperFactory.getLog(ManifestUtl.class);

    private ManifestUtl() {
    }

    public static Manifest loadJAR(Class<?> clazz) {
        String s = clazz.getResource(clazz.getSimpleName() + ".class").toExternalForm();
        String jar = s.substring(0, s.lastIndexOf(clazz.getPackage().getName().replace('.', '/')));
        URL url = null;
        InputStream is = null;
        try {
            url = new URL(jar + "META-INF/MANIFEST.MF");
            is = url.openStream();
        }
        catch (MalformedURLException e) {
            logger.debug((Object)e);
            throw ExceptionUtil.convertRuntimeException(e);
        }
        catch (IOException e) {
            logger.debug((Object)e);
            throw ExceptionUtil.convertRuntimeException(e);
        }
        return ManifestUtl.loadJAR(is);
    }

    public static Manifest loadJAR(InputStream is) {
        Manifest mf = null;
        try {
            mf = new Manifest(is);
        }
        catch (IOException e) {
            logger.debug((Object)e);
            throw ExceptionUtil.convertRuntimeException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return mf;
    }

    public static String getValue(Manifest mf, String key) {
        String value = null;
        try {
            value = mf.getMainAttributes().getValue(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value == null ? "" : value;
    }
}

