/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.common.util;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class OpenAMNamingUtil {
    public static final String VALUES_ATTR_NAME = "Values";
    public static final String SERVICE_NAME = "iPlanetAMWebAgentService";
    public static final String SUBJECT_ID_KEY = "id";
    public static final String SUBJECT_TYPE = "AMIdentitySubject";
    public static final String SUBJECT_INCLUDE_TYPE = "inclusive";
    public static final String SUBJECT_REFERRAL_TYPE = "SubOrgReferral";
    public static final String SUBJECT_REFERRAL_OWNER_KEY = "o";
    public static final String RULE_ATTR_GETMETHOD_NAME = "GET";
    public static final String RULE_ATTR_POSTMETHOD_NAME = "POST";
    private static final String RULE_NAME_PREFIX = "rule_";
    private static final String SUBJECT_NAME_PREFIX = "subject_";
    private static final String SUBJECTS_NAME_PREFIX = "subjects_";

    private OpenAMNamingUtil() {
    }

    public static Map<String, String> splitValue(String values) {
        String[] items;
        HashMap<String, String> kv = new HashMap<String, String>();
        for (String item : items = values.split(",")) {
            String[] s = item.split("=");
            String key = s[0].trim();
            String value = s[1].trim();
            if (kv.containsKey(key)) {
                value = (String)kv.get(key) + "," + value;
            }
            kv.put(key, value);
        }
        return kv;
    }

    public static String generateRuleName() {
        return OpenAMNamingUtil.generateUUID(RULE_NAME_PREFIX);
    }

    public static String generateSubjectName() {
        return OpenAMNamingUtil.generateUUID(SUBJECT_NAME_PREFIX);
    }

    public static String generateSubjectsName() {
        return OpenAMNamingUtil.generateUUID(SUBJECTS_NAME_PREFIX);
    }

    private static String generateUUID(String prefix) {
        return prefix + UUID.randomUUID().toString();
    }
}

