/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.common.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import jp.co.ogis_ri.citk.policytool.common.logging.LogWrapperFactory;
import jp.co.ogis_ri.citk.policytool.common.util.ExceptionUtil;
import org.apache.commons.logging.Log;

public class StreamUtil {
    private static final Log logger = LogWrapperFactory.getLog(StreamUtil.class);

    private StreamUtil() {
    }

    public static List<String> toTextLine(InputStream inputStream) {
        ArrayList<String> context = new ArrayList<String>();
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            String line;
            inputStreamReader = new InputStreamReader(inputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((line = bufferedReader.readLine()) != null) {
                context.add(line);
            }
        }
        catch (IOException e) {
            logger.debug((Object)e.getMessage());
            throw ExceptionUtil.convertRuntimeException(e);
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException e) {}
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {}
            }
        }
        return context;
    }

    public static String toString(InputStream inputStream) {
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        try {
            int ch;
            inputStreamReader = new InputStreamReader(inputStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((ch = inputStreamReader.read()) != -1) {
                printWriter.print((char)ch);
            }
        }
        catch (IOException e) {
            logger.debug((Object)e.getMessage());
            throw ExceptionUtil.convertRuntimeException(e);
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException e) {}
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {}
            }
            if (stringWriter != null) {
                try {
                    stringWriter.close();
                }
                catch (IOException e) {}
            }
            if (printWriter != null) {
                printWriter.close();
            }
        }
        return stringWriter.toString();
    }

    public static byte[] toByteArray(InputStream inputStream) {
        return StreamUtil.toString(inputStream).getBytes();
    }
}

