/*
 * Decompiled with CFR 0.152.
 */
package jp.co.ogis_ri.citk.policytool.common.util;

import java.io.UnsupportedEncodingException;
import jp.co.ogis_ri.citk.policytool.common.logging.LogWrapperFactory;
import jp.co.ogis_ri.citk.policytool.common.util.ExceptionUtil;
import org.apache.commons.logging.Log;

public class StringUtil {
    private static final Log logger = LogWrapperFactory.getLog(StringUtil.class);
    public static final String CHARSET_UTF8 = "UTF-8";
    public static final String CHARSET_SHIFT_JIS = "Shift_JIS";
    public static final String CHARSET_WIN31J = "windows-31j";
    private static final String SHORT_STR = "...";

    private StringUtil() {
    }

    public static String encoding(byte[] b, String charsetName) {
        String result = null;
        try {
            result = new String(b, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            logger.debug((Object)e.getMessage());
            ExceptionUtil.convertRuntimeException(e);
        }
        return result;
    }

    public static byte[] encoding(String s, String charsetName) {
        byte[] result = null;
        try {
            result = s.getBytes(charsetName);
        }
        catch (UnsupportedEncodingException e) {
            logger.debug((Object)e.getMessage());
            ExceptionUtil.convertRuntimeException(e);
        }
        return result;
    }

    public static String shortString(String s, int length) {
        if (s == null) {
            return "";
        }
        if (length <= SHORT_STR.length()) {
            return s;
        }
        return s.length() <= length ? s : s.substring(0, length - SHORT_STR.length()) + SHORT_STR;
    }
}

